/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.ClientFileChooserCardinality;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.filters.ClientFileAllFilter;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.client.util.filechooser.filters.ClientFileMultipleTypesFilter;
import csbase.client.util.filechooser.filters.ClientFileSingleTypeFilter;
import csbase.logic.ClientFile;
import csbase.logic.ClientSGAFile;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class ClientSGAFileChooserUtil {
    public static ClientSGAFile browseSingleFileInOpenMode(Window window, String title, List<String> fileCodes, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.newBrowseSingleFileInOpenMode(window, title, fileCodes, currentDirectory, allowAll, ClientFileChooserSelectionMode.FILES_ONLY);
    }

    public static ClientSGAFile browseSingleDirectoryInOpenMode(Window window, String title, List<String> fileCodes, boolean allowAll, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.newBrowseSingleFileInOpenMode(window, title, fileCodes, currentDirectory, allowAll, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
    }

    public static List<ClientSGAFile> browseMultipleFilesInOpenMode(Window window, String title, List<String> fileCodes, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.newBrowseMultipleFilesInOpenMode(window, title, fileCodes, currentDirectory, ClientFileChooserSelectionMode.FILES_ONLY);
    }

    public static List<ClientSGAFile> browseMultipleDirectoryInOpenMode(Window window, String title, List<String> fileCodes, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.newBrowseMultipleFilesInOpenMode(window, title, fileCodes, currentDirectory, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
    }

    public static ClientSGAFile browseSingleFileInSaveMode(Window window, String title, List<String> fileCodes, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.newBrowseSingleFileInSaveMode(window, title, fileCodes, currentDirectory, ClientFileChooserSelectionMode.FILES_ONLY);
    }

    public static ClientSGAFile browseSingleDirectoryInSaveMode(Window window, String title, List<String> fileCodes, ClientSGAFile currentDirectory) {
        return ClientSGAFileChooserUtil.newBrowseSingleFileInSaveMode(window, title, fileCodes, currentDirectory, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
    }

    private static ClientSGAFile newBrowseSingleFileInOpenMode(Window window, String title, List<String> fileCodes, ClientSGAFile currentDirectory, boolean allowAll, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setCurrentDirectory((ClientFile)currentDirectory);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.OPEN);
        chooser.setLocalHomeButtonVisible(false);
        chooser.setLocalRootButtonVisible(false);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        if (fileCodes != null) {
            if (fileCodes.size() > 1) {
                filters.add(new ClientFileMultipleTypesFilter(fileCodes));
            }
            for (String fileCode : fileCodes) {
                ClientFileSingleTypeFilter flt = new ClientFileSingleTypeFilter(fileCode);
                filters.add(flt);
            }
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null || selected.size() == 0) {
            return null;
        }
        ClientSGAFile first = (ClientSGAFile)selected.get(0);
        return first;
    }

    private static List<ClientSGAFile> newBrowseMultipleFilesInOpenMode(Window window, String title, List<String> fileCodes, ClientSGAFile currentDirectory, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setCurrentDirectory((ClientFile)currentDirectory);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.OPEN);
        chooser.setLocalHomeButtonVisible(false);
        chooser.setLocalRootButtonVisible(false);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.MULTIPLE_CHOOSE);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        if (fileCodes != null) {
            if (fileCodes.size() > 1) {
                filters.add(new ClientFileMultipleTypesFilter(fileCodes));
            }
            for (String fileCode : fileCodes) {
                ClientFileSingleTypeFilter flt = new ClientFileSingleTypeFilter(fileCode);
                filters.add(flt);
            }
        }
        filters.add(new ClientFileAllFilter());
        chooser.setViewFilters(filters);
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null) {
            return null;
        }
        ArrayList<ClientSGAFile> sgaFileSelected = new ArrayList<ClientSGAFile>();
        for (ClientFile clientFile : selected) {
            ClientSGAFile clientLocalFile = (ClientSGAFile)clientFile;
            sgaFileSelected.add(clientLocalFile);
        }
        return sgaFileSelected;
    }

    private static ClientSGAFile newBrowseSingleFileInSaveMode(Window window, String title, List<String> fileCodes, ClientSGAFile currentDirectory, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setCurrentDirectory((ClientFile)currentDirectory);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.SAVE);
        chooser.setLocalHomeButtonVisible(false);
        chooser.setLocalRootButtonVisible(false);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        if (fileCodes != null) {
            if (fileCodes.size() > 1) {
                filters.add(new ClientFileMultipleTypesFilter(fileCodes));
            }
            for (String fileCode : fileCodes) {
                ClientFileSingleTypeFilter flt = new ClientFileSingleTypeFilter(fileCode);
                filters.add(flt);
            }
        }
        filters.add(new ClientFileAllFilter());
        chooser.setViewFilters(filters);
        chooser.setVisible(true);
        String[] selectedSavePath = chooser.getSelectedSavePath();
        if (selectedSavePath == null || selectedSavePath.length <= 0) {
            return null;
        }
        String path = ClientSGAFileChooserUtil.buildAbsolutePath(selectedSavePath, currentDirectory.getSeparator());
        ClientSGAFile clientSGAFile = new ClientSGAFile(currentDirectory.getSGAName(), path);
        if (selectionMode == ClientFileChooserSelectionMode.DIRECTORIES_ONLY) {
            clientSGAFile.setDir(true);
        }
        return clientSGAFile;
    }

    private static String buildAbsolutePath(String[] path, String separator) {
        StringBuilder absolutePath = new StringBuilder();
        for (String p : path) {
            if (p.trim().isEmpty()) continue;
            absolutePath.append(separator);
            absolutePath.append(p);
        }
        return absolutePath.toString();
    }
}

