/*
 * Decompiled with CFR 0.152.
 */
package csbase.client;

import csbase.exception.PermissionException;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ProjectFileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.regex.Pattern;
import tecgraf.javautils.core.io.FileUtils;

public class ClientLocalFile
implements ClientFile {
    private final File file;
    private RandomAccessFile randomFile = null;

    public final boolean exists() {
        return this.file.exists();
    }

    public String getName() {
        return this.file.getName();
    }

    public void open(boolean readOnly) throws Exception {
        if (this.file.isDirectory()) {
            throw new Exception("Diret\u00f3rio n\u00e3o pode ter open()!");
        }
        String mode = readOnly ? "r" : "rws";
        this.checkReadPermission();
        if (!readOnly) {
            this.checkWritePermission();
        }
        this.randomFile = new RandomAccessFile(this.file, mode);
    }

    public int read(byte[] dst, long position) throws Exception {
        this.checkReadPermission();
        if (this.randomFile == null) {
            throw new IllegalStateException("Arquivo n\u00e3o foi aberto!");
        }
        this.randomFile.seek(position);
        return this.randomFile.read(dst, 0, dst.length);
    }

    public int read(byte[] dst, int off, int len, long position) throws Exception {
        this.checkReadPermission();
        if (this.randomFile == null) {
            throw new IllegalStateException("Arquivo n\u00e3o foi aberto!");
        }
        this.randomFile.seek(position);
        return this.randomFile.read(dst, off, len);
    }

    public long size() {
        return this.file.length();
    }

    public String getStringPath() {
        return this.file.getAbsolutePath();
    }

    public String[] getPath() {
        String path = this.file.getPath();
        String[] splitPath = path.split(Pattern.quote(File.separator));
        return splitPath;
    }

    public InputStream getInputStream() throws IOException {
        this.checkReadPermission();
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkWritePermission();
        return new FileOutputStream(this.file);
    }

    public ClientFile[] getChildren() {
        this.checkReadPermission();
        if (!this.file.isDirectory()) {
            return null;
        }
        if (!this.file.canRead()) {
            return null;
        }
        ArrayList<ClientLocalFile> list = new ArrayList<ClientLocalFile>();
        for (File f : this.file.listFiles()) {
            list.add(new ClientLocalFile(f));
        }
        if (list.size() == 0) {
            return null;
        }
        ClientFile[] array = list.toArray(new ClientFile[list.size()]);
        return array;
    }

    public String getType() {
        String localFileName = this.getName();
        String localFileExtension = FileUtils.getFileExtension((String)localFileName);
        ProjectFileType pft = ProjectFileType.getProjectFileTypeFromExtension((String)localFileExtension, (boolean)this.isDirectory());
        return pft.getCode();
    }

    public ClientLocalFile getParent() {
        File parentFile = this.file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        ClientLocalFile parent = new ClientLocalFile(parentFile);
        if (!parent.isDirectory()) {
            throw new IllegalStateException("Parent n\u00e3o \u00e9 diret\u00f3rio!");
        }
        return parent;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long getModificationDate() {
        if (!this.file.canRead()) {
            return 0L;
        }
        long lastModified = this.file.lastModified();
        return lastModified;
    }

    public void close(boolean force) throws IOException {
        if (this.randomFile != null) {
            RandomAccessFile raf = this.randomFile;
            if (force) {
                this.randomFile = null;
            }
            raf.close();
            this.randomFile = null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientLocalFile)) {
            return false;
        }
        ClientLocalFile other = (ClientLocalFile)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public ClientFileType getClientFileType() {
        return ClientFileType.LOCAL;
    }

    private void checkReadPermission() {
        if (this.exists() && !this.canRead()) {
            throw new PermissionException();
        }
    }

    private void checkWritePermission() {
        if (this.exists() && !this.canWrite()) {
            throw new PermissionException();
        }
    }

    public void write(byte[] src, int off, int len, long position) throws IOException {
        if (this.randomFile == null) {
            throw new IllegalStateException("Arquivo n\u00e3o foi aberto!");
        }
        this.randomFile.seek(position);
        this.randomFile.write(src, off, len);
    }

    public void write(byte[] src, long position) throws IOException {
        if (this.randomFile == null) {
            throw new IllegalStateException("Arquivo n\u00e3o foi aberto!");
        }
        this.randomFile.seek(position);
        this.randomFile.write(src);
    }

    public long position() throws IOException {
        long fp = this.randomFile.getFilePointer();
        return fp;
    }

    public void position(long newPosition) throws IOException {
        this.randomFile.seek(newPosition);
    }

    public boolean canExecute() {
        return this.file.canExecute();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public ClientLocalFile(File file) {
        if (file == null) {
            String err = "Null detectado na cria\u00e7\u00e3o de ClientLocalFile!";
            throw new IllegalArgumentException("Null detectado na cria\u00e7\u00e3o de ClientLocalFile!");
        }
        this.file = file;
        this.randomFile = null;
    }

    public boolean rename(String newName) {
        File file2 = new File(newName);
        if (file2.exists()) {
            return false;
        }
        return this.file.renameTo(file2);
    }
}

