/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.dircontents;

import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileCellRenderer;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.ProjectTreeSelectionEvent;
import csbase.client.project.ProjectTreeSelectionListener;
import csbase.client.project.tasks.FileTypeIconCellRenderer;
import csbase.client.project.tasks.GetChildrenTask;
import csbase.client.util.DateTableCellRenderer;
import csbase.client.util.SizeTableCellRenderer;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientProjectFileComparator;
import csbase.logic.CommonClientProject;
import csbase.logic.FileTypeComparator;
import csbase.logic.NoHiddenFileFilter;
import csbase.logic.ProjectFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public class DirectoryContentsPanel
extends JPanel {
    static final int TYPE_COL_INDEX = 0;
    static final int NAME_COL_INDEX = 1;
    static final int SIZE_COL_INDEX = 2;
    static final int DATE_COL_INDEX = 3;
    private SortableTable dirContentsTable;
    private ObjectTableModel<ClientProjectFile> dirModel;
    private JLabel statusBar;
    private String lastStatusBarText = " ";
    private ClientProjectFile previousSelectedFile;
    private ProjectTree projectTree;
    private JScrollPane scrollPane;
    private ProjectFileFilter filter = null;

    private void clear() {
        this.clearModel();
        this.lastStatusBarText = " ";
        this.statusBar.setText(this.lastStatusBarText);
    }

    private void clearModel() {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DirectoryContentsPanel.this.dirModel.clear();
            }
        });
    }

    private void display(ClientProjectFile file) {
        if (file.isDirectory()) {
            this.displayDir(file);
        } else {
            this.displayFile(file);
        }
        this.statusBar.setText(this.lastStatusBarText);
    }

    private void display(ClientProjectFile[] files) {
        ArrayList<ClientProjectFile> fileList = new ArrayList<ClientProjectFile>();
        for (ClientProjectFile file : files) {
            fileList.add(file);
        }
        this.updateModel(fileList);
        this.lastStatusBarText = this.getStatusBarTextForFiles(files);
        this.statusBar.setText(this.lastStatusBarText);
    }

    private void displayDir(ClientProjectFile dir) {
        ArrayList<ClientProjectFile> dirList = new ArrayList<ClientProjectFile>();
        ClientProjectFile[] children = GetChildrenTask.runTask(dir);
        NoHiddenFileFilter noDotFileFilter = NoHiddenFileFilter.getInstance();
        boolean showHiddenFiles = DesktopFrame.getInstance().shouldShowHiddenFiles();
        long size = 0L;
        ClientProjectFile[] arr$ = children;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ClientProjectFile element;
            ClientProjectFile child = element = arr$[i$];
            if (!showHiddenFiles && !noDotFileFilter.accept(child) || this.filter != null && !this.filter.accept(child)) continue;
            dirList.add(child);
            if (child.isDirectory()) continue;
            size += child.size();
        }
        this.updateModel(dirList);
        this.lastStatusBarText = this.getStatusBarTextForFiles(dirList.size(), size);
    }

    private void displayFile(ClientProjectFile file) {
        ArrayList<ClientProjectFile> fileList = new ArrayList<ClientProjectFile>();
        fileList.add(file);
        this.updateModel(fileList);
        this.lastStatusBarText = this.getStatusBarTextForFile(file);
    }

    private String getStatusBarTextForFile(ClientProjectFile file) {
        long fileSize = file.size();
        String formattedFileSize = FormatUtils.formatSize((long)fileSize, (int)2);
        return MessageFormat.format(LNG.get((String)"DIR_CONTENTS_STATUS_BAR"), 1, formattedFileSize);
    }

    private String getStatusBarTextForFiles(ClientProjectFile[] files) {
        int fileCount = files.length;
        try {
            long dirSize = 0L;
            for (int i = 0; i < fileCount; ++i) {
                ClientProjectFile file = files[i];
                if (file.isDirectory()) continue;
                dirSize += file.size();
            }
            return this.getStatusBarTextForFiles(fileCount, dirSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            return LNG.get((String)"DIR_CONTENTS_STATUS_BAR_ERROR");
        }
    }

    private String getStatusBarTextForFiles(int fileCount, long totalSize) {
        String formattedDirSize = FormatUtils.formatSize((long)totalSize, (int)2);
        return MessageFormat.format(LNG.get((String)"DIR_CONTENTS_STATUS_BAR"), fileCount, formattedDirSize);
    }

    public void setFilter(ProjectFileFilter filter) {
        this.filter = filter;
    }

    private void update() {
        this.update(this.projectTree.getSelectedFiles(), true);
    }

    private void update(ClientProjectFile[] selectedFiles, boolean refresh) {
        if (selectedFiles == null || selectedFiles.length == 0) {
            this.clear();
            this.previousSelectedFile = null;
        } else if (selectedFiles.length == 1) {
            ClientProjectFile selFile = selectedFiles[0];
            if (refresh || !selFile.equals((Object)this.previousSelectedFile)) {
                this.display(selFile);
                this.previousSelectedFile = selFile;
            }
        } else {
            this.display(selectedFiles);
            this.previousSelectedFile = null;
        }
    }

    private void updateModel(final List<ClientProjectFile> fileList) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DirectoryContentsPanel.this.dirModel.setRows(fileList);
            }
        });
    }

    public DirectoryContentsPanel(ProjectTree projectTree) {
        this.projectTree = projectTree;
        this.projectTree.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }
        });
        this.projectTree.addTreeSelectionListener(new ProjectTreeSelectionListener(){

            @Override
            public void update(ProjectTreeSelectionEvent event) {
                DirectoryContentsPanel.this.update(event.getSelectedFiles(), false);
            }
        });
        MyObjectTableProvider provider = new MyObjectTableProvider();
        this.dirModel = new ObjectTableModel(new ArrayList(), (ObjectTableProvider)provider);
        this.dirContentsTable = new SortableTable(this.dirModel);
        this.dirContentsTable.setNoSortStateEnabled(true);
        FileTypeComparator iconComparator = new FileTypeComparator();
        this.dirContentsTable.setComparator(0, (Comparator)iconComparator);
        ClientProjectFileComparator comparator = new ClientProjectFileComparator();
        this.dirContentsTable.setComparator(1, (Comparator)comparator);
        this.dirContentsTable.sort(1, SortOrder.ASCENDING);
        this.dirContentsTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTableCellRenderer());
        this.dirContentsTable.setDefaultRenderer(Long.class, (TableCellRenderer)new SizeTableCellRenderer());
        TableColumnModel columnModel = this.dirContentsTable.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(1);
        nameColumn.setCellRenderer(new ProjectFileCellRenderer());
        TableColumn typeColumn = columnModel.getColumn(0);
        typeColumn.setCellRenderer(new FileTypeIconCellRenderer());
        typeColumn.setMaxWidth(25);
        typeColumn.setMinWidth(25);
        typeColumn.setPreferredWidth(25);
        TableColumn sizeColumn = columnModel.getColumn(2);
        sizeColumn.setPreferredWidth(80);
        sizeColumn.setMaxWidth(80);
        TableColumn dateColumn = columnModel.getColumn(3);
        dateColumn.setPreferredWidth(150);
        dateColumn.setMaxWidth(150);
        this.dirContentsTable.setShowGrid(false);
        this.dirContentsTable.setRowMargin(0);
        projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void projectClosed(CommonClientProject project) {
                DirectoryContentsPanel.this.clear();
            }

            @Override
            public void projectInfoModified() {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void projectRemoved() {
                DirectoryContentsPanel.this.clear();
            }
        });
        this.scrollPane = new JScrollPane((Component)this.dirContentsTable);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.statusBar = new JLabel();
        this.statusBar.setText(this.lastStatusBarText);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusBar, "South");
        this.setPreferredSize(new Dimension(220, 100));
    }

    private static class MyObjectTableProvider
    implements ObjectTableProvider {
        private static final Class<?>[] COL_CLASSES = new Class[]{ImageIcon.class, ClientProjectFile.class, Long.class, Date.class};
        private static final String[] COL_NAMES = new String[]{"", LNG.get((String)"DIR_CONTENTS_NAME"), LNG.get((String)"DIR_CONTENTS_SIZE"), LNG.get((String)"DIR_CONTENTS_DATE")};

        private MyObjectTableProvider() {
        }

        public Object getCellValue(Object row, int col) {
            ClientProjectFile file = (ClientProjectFile)row;
            switch (col) {
                case 0: {
                    return file;
                }
                case 1: {
                    return file;
                }
                case 2: {
                    return this.getSize(file);
                }
                case 3: {
                    return this.getDate(file);
                }
            }
            return null;
        }

        public Class<?>[] getColumnClasses() {
            return COL_CLASSES;
        }

        public String[] getColumnNames() {
            return COL_NAMES;
        }

        private Date getDate(ClientProjectFile file) {
            return new Date(file.getModificationDate());
        }

        private Long getSize(ClientProjectFile file) {
            if (file.isDirectory()) {
                return -1L;
            }
            return file.size();
        }
    }
}

