/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.ClientLocalFile;
import csbase.client.project.ClientProjectFileType;
import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.ClientFileChooserCardinality;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.filters.ClientFileAllFilter;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.client.util.filechooser.filters.ClientFileMultipleTypesFilter;
import csbase.client.util.filechooser.filters.ClientFileSingleTypeFilter;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ClientLocalFileChooserUtil {
    public static final ClientLocalFile browseSingleFileInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientLocalFile currentDirectory) {
        boolean useNewChooser = ClientLocalFileChooserUtil.useNewChooser();
        if (useNewChooser) {
            return ClientLocalFileChooserUtil.newBrowseSingleFileInOpenMode(window, fileTypes, title, allowAll, currentDirectory, ClientFileChooserSelectionMode.FILES_ONLY);
        }
        return ClientLocalFileChooserUtil.oldBrowseSingleFileInOpenMode(window, fileTypes, title, allowAll, currentDirectory, 0);
    }

    public static final List<ClientLocalFile> browseMultipleFilesInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientLocalFile currentDirectory) {
        boolean useNewChooser = ClientLocalFileChooserUtil.useNewChooser();
        if (useNewChooser) {
            return ClientLocalFileChooserUtil.newBrowseMultipleFilesInOpenMode(window, fileTypes, title, allowAll, currentDirectory, ClientFileChooserSelectionMode.FILES_ONLY);
        }
        return ClientLocalFileChooserUtil.oldBrowseMultipleFilesInOpenMode(window, fileTypes, title, allowAll, currentDirectory, 0);
    }

    public static final List<ClientLocalFile> browseMultipleDirectoriesInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientLocalFile currentDirectory) {
        boolean useNewChooser = ClientLocalFileChooserUtil.useNewChooser();
        if (useNewChooser) {
            return ClientLocalFileChooserUtil.newBrowseMultipleFilesInOpenMode(window, fileTypes, title, allowAll, currentDirectory, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
        }
        return ClientLocalFileChooserUtil.oldBrowseMultipleFilesInOpenMode(window, fileTypes, title, allowAll, currentDirectory, 1);
    }

    public static final ClientLocalFile browseSingleFileInSaveMode(Window window, Collection<String> fileCodes, String defaultFileType, String title, boolean allowAll, ClientLocalFile currentDirectory) {
        boolean useNewChooser = ClientLocalFileChooserUtil.useNewChooser();
        if (useNewChooser) {
            return ClientLocalFileChooserUtil.newBrowseSingleFileInSaveMode(window, fileCodes, defaultFileType, title, allowAll, currentDirectory, ClientFileChooserSelectionMode.FILES_ONLY);
        }
        return ClientLocalFileChooserUtil.oldBrowseSingleFileInSaveMode(window, fileCodes, defaultFileType, title, allowAll, currentDirectory, 0);
    }

    public static final ClientLocalFile browseSingleDirectoryInSaveMode(Window window, Collection<String> fileTypes, String defaultFileType, String title, boolean allowAll, ClientLocalFile currentDirectory) {
        boolean useNewChooser = ClientLocalFileChooserUtil.useNewChooser();
        if (useNewChooser) {
            return ClientLocalFileChooserUtil.newBrowseSingleFileInSaveMode(window, fileTypes, defaultFileType, title, allowAll, currentDirectory, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
        }
        return ClientLocalFileChooserUtil.oldBrowseSingleFileInSaveMode(window, fileTypes, defaultFileType, title, allowAll, currentDirectory, 1);
    }

    public static final ClientLocalFile browseSingleDirectoryInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientLocalFile currentDirectory) {
        boolean useNewChooser = ClientLocalFileChooserUtil.useNewChooser();
        if (useNewChooser) {
            return ClientLocalFileChooserUtil.newBrowseSingleFileInOpenMode(window, fileTypes, title, allowAll, currentDirectory, ClientFileChooserSelectionMode.DIRECTORIES_ONLY);
        }
        return ClientLocalFileChooserUtil.oldBrowseSingleFileInOpenMode(window, fileTypes, title, allowAll, currentDirectory, 1);
    }

    private static ClientLocalFile newBrowseSingleFileInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientLocalFile currentDirectory, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.OPEN);
        chooser.setLocalHomeButtonVisible(true);
        chooser.setLocalRootButtonVisible(true);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        ClientLocalFile currentDir = ClientLocalFileChooserUtil.getCurrentDirectory(currentDirectory);
        chooser.setCurrentDirectory(currentDir);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        if (fileTypes != null) {
            if (fileTypes.size() > 1) {
                filters.add(new ClientFileMultipleTypesFilter(fileTypes));
            }
            for (String fileType : fileTypes) {
                ClientFileSingleTypeFilter flt = new ClientFileSingleTypeFilter(fileType);
                filters.add(flt);
            }
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        if (!filters.isEmpty()) {
            chooser.setSelectedFilter((ClientFileFilterInterface)filters.get(0));
        }
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null || selected.size() == 0) {
            return null;
        }
        ClientLocalFile first = (ClientLocalFile)selected.get(0);
        return first;
    }

    private static List<ClientLocalFile> newBrowseMultipleFilesInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll, ClientLocalFile currentDirectory, ClientFileChooserSelectionMode selectionMode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(ClientFileChooserType.OPEN);
        chooser.setLocalHomeButtonVisible(true);
        chooser.setLocalRootButtonVisible(true);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.MULTIPLE_CHOOSE);
        ClientLocalFile currentDir = ClientLocalFileChooserUtil.getCurrentDirectory(currentDirectory);
        chooser.setCurrentDirectory(currentDir);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        if (fileTypes != null) {
            if (fileTypes.size() > 1) {
                filters.add(new ClientFileMultipleTypesFilter(fileTypes));
            }
            for (String fileType : fileTypes) {
                ClientFileSingleTypeFilter flt = new ClientFileSingleTypeFilter(fileType);
                filters.add(flt);
            }
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        if (!filters.isEmpty()) {
            chooser.setSelectedFilter((ClientFileFilterInterface)filters.get(0));
        }
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null) {
            return null;
        }
        ArrayList<ClientLocalFile> localSelected = new ArrayList<ClientLocalFile>();
        for (ClientFile clientFile : selected) {
            ClientLocalFile clientLocalFile = (ClientLocalFile)clientFile;
            localSelected.add(clientLocalFile);
        }
        return localSelected;
    }

    private static ClientLocalFile newBrowseSingleFileInSaveMode(Window window, Collection<String> fileTypes, String defaultFileType, String title, boolean allowAll, ClientLocalFile currentDirectory, ClientFileChooserSelectionMode mode) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        chooser.setTitle(title);
        chooser.setSelectionMode(mode);
        chooser.setSelectionType(ClientFileChooserType.SAVE);
        chooser.setLocalHomeButtonVisible(true);
        chooser.setLocalRootButtonVisible(true);
        chooser.setProjectHomeButtonVisible(false);
        chooser.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        ClientLocalFile currentDir = ClientLocalFileChooserUtil.getCurrentDirectory(currentDirectory);
        chooser.setCurrentDirectory(currentDir);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        ArrayList<String> allFileTypes = new ArrayList<String>();
        if (defaultFileType != null) {
            allFileTypes.add(defaultFileType);
        }
        for (String fileType : fileTypes) {
            if (allFileTypes.contains(fileType)) continue;
            allFileTypes.add(fileType);
        }
        ClientFileSingleTypeFilter defaultFilter = null;
        for (String fileType : allFileTypes) {
            ClientFileSingleTypeFilter filter = new ClientFileSingleTypeFilter(fileType);
            filters.add(filter);
            if (defaultFileType == null || !defaultFileType.equals(fileType)) continue;
            defaultFilter = filter;
        }
        if (allFileTypes.size() > 1) {
            filters.add(new ClientFileMultipleTypesFilter(allFileTypes));
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        if (defaultFilter != null) {
            chooser.setSelectedFilter(defaultFilter);
        }
        chooser.setVisible(true);
        String[] selectedSavePath = chooser.getSelectedSavePath();
        if (selectedSavePath == null || selectedSavePath.length <= 0) {
            return null;
        }
        String path = FileUtils.joinPath((String[])selectedSavePath);
        File file = new File(path);
        ClientLocalFile clientLocalFile = new ClientLocalFile(file);
        return clientLocalFile;
    }

    private static ClientLocalFile getCurrentDirectory(ClientLocalFile currentDir) {
        ArrayList<ClientLocalFile> dirs = new ArrayList<ClientLocalFile>();
        dirs.add(currentDir);
        dirs.add(ClientFileChooserUtils.getLocalHomeDirectory());
        dirs.addAll(ClientFileChooserUtils.getLocalRootDirectories());
        dirs.add(new ClientLocalFile(new File(".")));
        for (ClientLocalFile dir : dirs) {
            if (dir == null || !dir.isDirectory() || !dir.exists()) continue;
            return dir;
        }
        return null;
    }

    private static ClientLocalFile oldBrowseSingleFileInOpenMode(Window window, Collection<String> fileCodes, String title, boolean allowAll, ClientLocalFile currentDirectory, int selectionMode) {
        JFileChooser fc = ClientLocalFileChooserUtil.createOldLocalFileChooser(fileCodes, title, allowAll, currentDirectory, selectionMode);
        fc.setDialogType(0);
        fc.setMultiSelectionEnabled(false);
        int returnVal = fc.showOpenDialog(window);
        if (returnVal != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        if (file == null || !file.exists() || !file.canRead()) {
            String cls = ClientLocalFileChooserUtil.class.getSimpleName();
            String err = LNG.get((String)(cls + ".file.not.found.error"));
            StandardDialogs.showErrorDialog((Component)window, (String)"", (String)err);
            return null;
        }
        ClientLocalFile localFile = new ClientLocalFile(file);
        return localFile;
    }

    private static List<ClientLocalFile> oldBrowseMultipleFilesInOpenMode(Window window, Collection<String> fileCodes, String title, boolean allowAll, ClientLocalFile currentDirectory, int selectionMode) {
        JFileChooser fc = ClientLocalFileChooserUtil.createOldLocalFileChooser(fileCodes, title, allowAll, currentDirectory, selectionMode);
        fc.setDialogType(0);
        fc.setMultiSelectionEnabled(true);
        int returnVal = fc.showOpenDialog(window);
        if (returnVal != 0) {
            return null;
        }
        File[] files = fc.getSelectedFiles();
        if (files == null || files.length == 0) {
            String cls = ClientLocalFileChooserUtil.class.getSimpleName();
            String err = LNG.get((String)(cls + ".file.not.found.error"));
            StandardDialogs.showErrorDialog((Component)window, (String)"", (String)err);
            return null;
        }
        ArrayList<ClientLocalFile> localFiles = new ArrayList<ClientLocalFile>();
        for (File file : files) {
            ClientLocalFile localFile = new ClientLocalFile(file);
            localFiles.add(localFile);
        }
        return localFiles;
    }

    private static JFileChooser createOldLocalFileChooser(Collection<String> fileCodes, String title, boolean allowAll, ClientLocalFile currentDirectory, int selectionMode) {
        JFileChooser fc = new JFileChooser();
        if (fileCodes != null) {
            for (String fileCode : fileCodes) {
                fc.addChoosableFileFilter(new LocalFileFilter(fileCode));
            }
        }
        if (allowAll) {
            fc.setAcceptAllFileFilterUsed(true);
        }
        fc.setFileView(new LocalFileView());
        fc.setFileSelectionMode(selectionMode);
        fc.setDialogTitle(title);
        ClientLocalFile dir = ClientLocalFileChooserUtil.getCurrentDirectory(currentDirectory);
        if (dir != null) {
            fc.setCurrentDirectory(new File(dir.getStringPath()));
        }
        return fc;
    }

    private static ClientLocalFile oldBrowseSingleFileInSaveMode(Window window, Collection<String> fileCodes, String defaultFileCode, String title, boolean allowAll, ClientLocalFile currentDirectory, int mode) {
        JFileChooser fc = ClientLocalFileChooserUtil.createOldLocalFileChooser(fileCodes, title, allowAll, currentDirectory, mode);
        fc.setFileView(new LocalFileView());
        ClientLocalFile dir = ClientLocalFileChooserUtil.getCurrentDirectory(currentDirectory);
        if (dir != null) {
            fc.setCurrentDirectory(new File(dir.getStringPath()));
        }
        fc.setMultiSelectionEnabled(false);
        fc.setDialogType(1);
        int returnVal = fc.showSaveDialog(window);
        if (returnVal != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        if (file == null) {
            return null;
        }
        return new ClientLocalFile(file);
    }

    private static boolean useNewChooser() {
        try {
            ConfigurationManager cnfManager = ConfigurationManager.getInstance();
            Configuration cnf = cnfManager.getConfiguration(ClientLocalFileChooserUtil.class);
            String propName = "new.chooser";
            Boolean newChooser = cnf.getOptionalBooleanProperty("new.chooser", false);
            return newChooser;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class LocalFileView
    extends FileView {
        LocalFileView() {
        }

        @Override
        public String getDescription(File file) {
            return null;
        }

        @Override
        public Icon getIcon(File file) {
            String path = file.getAbsolutePath();
            String extension = FileUtils.getFileExtension((String)path);
            ProjectFileType fileType = ProjectFileType.getProjectFileTypeFromExtension((String)extension, (boolean)file.isDirectory());
            String code = fileType.getCode();
            ClientProjectFileType projFileType = ClientProjectFileType.getFileType(code);
            ImageIcon icon = projFileType.getBaseIcon();
            return icon;
        }

        @Override
        public String getName(File file) {
            return null;
        }

        @Override
        public String getTypeDescription(File file) {
            String path = file.getAbsolutePath();
            String extension = FileUtils.getFileExtension((String)path);
            ProjectFileType fileType = ProjectFileType.getProjectFileTypeFromExtension((String)extension, (boolean)file.isDirectory());
            String desc = fileType.getDescription();
            return desc;
        }

        @Override
        public Boolean isTraversable(File file) {
            return null;
        }
    }

    private static final class LocalFileFilter
    extends FileFilter {
        private final String fileCode;

        @Override
        public boolean accept(File f) {
            String fileName;
            String extension;
            if (f.isDirectory()) {
                return true;
            }
            ProjectFileType fileType = ProjectFileType.getFileType((String)this.fileCode);
            List extensions = fileType.getExtensions();
            return extensions.contains(extension = FileUtils.getFileExtension((String)(fileName = f.getName())));
        }

        @Override
        public String getDescription() {
            ProjectFileType fileType = ProjectFileType.getFileType((String)this.fileCode);
            String desc = fileType.getDescription();
            desc = desc + " - ";
            List extensions = fileType.getExtensions();
            for (String extension : extensions) {
                desc = desc + " (*." + extension + ") ";
            }
            return desc;
        }

        private LocalFileFilter(String fileCode) {
            this.fileCode = fileCode;
        }
    }
}

