/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.CellModel;
import csbase.client.util.table.CellModelFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ReflectionCellModelFactory<R>
implements CellModelFactory<R> {
    private Constructor<? extends CellModel> cellModelClassConstrutor;

    public ReflectionCellModelFactory(Class<R> rowClass, Class<? extends CellModel> cellModelClass) {
        if (rowClass == null) {
            throw new IllegalArgumentException("O par\u00e2metro rowClass est\u00e1 nulo.");
        }
        if (cellModelClass == null) {
            throw new IllegalArgumentException("O par\u00e2metro cellModelClass est\u00e1 nulo.");
        }
        for (Class<R> currentRowClass = rowClass; currentRowClass != null && this.cellModelClassConstrutor == null; currentRowClass = currentRowClass.getSuperclass()) {
            try {
                this.cellModelClassConstrutor = cellModelClass.getConstructor(currentRowClass);
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (this.cellModelClassConstrutor == null) {
            throw new IllegalArgumentException(String.format("N\u00e3o foi encontrado um construtor adequado para criar modelos de c\u00e9lulas.\nA classe deveria possuir pelo menos um construtor p\u00fablico que recebe um \u00fanico argumento do tipo %s, ou de uma de suas superclasses.", rowClass.getName()));
        }
    }

    @Override
    public CellModel create(R rowValue) {
        try {
            return this.cellModelClassConstrutor.newInstance(rowValue);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

