/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.CopyFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.EditConfigurationFileAction;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportConfigurationFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveConfigurationFiles;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ConfigurationPathFactory;
import java.awt.datatransfer.DataFlavor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tecgraf.javautils.core.lng.LNG;

final class ConfigurationFileNode
extends AbstractFileInfoNode {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(ConfigurationFileNode.class, ConfigurationFileNode.class.getSimpleName());

    protected ConfigurationFileNode(VersionTree tree, AlgorithmVersionInfo version, FileInfo file) {
        super(tree, version, file, file1 -> new ConfigurationFileNode(tree, version, file1), false);
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CopyFile(this.getTree(), LNG.get((String)"algomanager.menu.config.copy")))));
        if (this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new PasteFile(this.getTree(), LNG.get((String)"algomanager.menu.config.paste"), DATA_FLAVOR))));
        } else if (this.getTree().getSelectionCount() == 1) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new EditConfigurationFileAction(this.getTree(), this.getVersion(), this.getFile()))));
        }
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new RemoveConfigurationFiles(this.getTree(), this.getVersion(), this.getSelectedFiles()))));
        if (!this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ExportConfigurationFile(this.getTree(), this.getVersion(), this.getFile()))));
        }
        return popupMenu;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return DATA_FLAVOR;
    }

    @Override
    protected final IPathFactory createSourcePathFactory(AbstractFileInfoNode.DataTransferObject dto) {
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        return new ConfigurationPathFactory(sourceVersion);
    }

    @Override
    protected final IPathFactory createTargetPathFactory() {
        return new ConfigurationPathFactory(this.getVersion());
    }
}

