/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.validation;

import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.validation.FlowNodeValidationResult;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class ValidationTranslator {
    public static String translateMessage(Validation validation) {
        List<StatusMessage> messages = ValidationTranslator.recursiveTranslateMessage(validation, null);
        StringBuilder builder = new StringBuilder();
        for (StatusMessage message : messages) {
            builder.append(message);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static List<StatusMessage> recursiveTranslateMessage(Validation validation, String prefix) {
        ArrayList<StatusMessage> messages = new ArrayList<StatusMessage>();
        String newPrefix = prefix;
        if (validation instanceof FlowNodeValidationResult) {
            newPrefix = ValidationTranslator.getElementName((FlowNodeValidationResult)validation);
        }
        if (validation.getChildren() != null) {
            for (Validation resultChild : validation.getChildren()) {
                messages.addAll(ValidationTranslator.recursiveTranslateMessage(resultChild, newPrefix));
            }
        } else if (validation.getMessage() != null && validation.getMessage().size() > 0) {
            messages.add(new StatusMessage(validation.isWellSucceeded(), ValidationTranslator.getMessage(validation.getMessage(), newPrefix)));
        }
        return messages;
    }

    public static String getElementName(FlowNodeValidationResult validation) {
        if (validation != null && validation.getElement() != null) {
            return "(" + ((FlowNode)validation.getElement()).getAlgorithmTitle() + ") ";
        }
        return null;
    }

    public static boolean hasLocalizedMessage(LocalizedMessage message) {
        if (message != null) {
            return LNG.hasKey((String)message.getKey());
        }
        return false;
    }

    public static String getMessage(List<LocalizedMessage> messages, String prefix) {
        StringBuilder builder = new StringBuilder();
        for (LocalizedMessage message : messages) {
            if (prefix != null) {
                builder.append(prefix);
            }
            if (ValidationTranslator.hasLocalizedMessage(message)) {
                String string = ValidationTranslator.getLocalizedMessage(message);
                string.replaceAll("\n", "\n\t");
                builder.append(string + "\n");
                continue;
            }
            builder.append(message.toString() + "\n");
        }
        return builder.toString();
    }

    public static String getLocalizedMessage(LocalizedMessage message) {
        if (message != null) {
            Object[] args = message.getArgs();
            String key = message.getKey();
            if (args != null && args.length > 0) {
                return LNG.get((String)key, (Object[])args);
            }
            return LNG.get((String)key);
        }
        return "";
    }

    public static class StatusMessage {
        public String message;
        public boolean status;

        public StatusMessage(boolean status, String message) {
            this.message = message;
            this.status = status;
        }
    }
}

