/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonAlgoFileRenameAction
extends AbstractVersionTreeNodeAction {
    public CommonAlgoFileRenameAction(VersionTree tree) {
        super(tree, LNG.get((String)"algomanager.menu.doc.rename"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.startRenamingAction();
    }

    public boolean renameFile(AlgorithmVersionInfo version, ClientAlgorithmFile.AlgorithmFileType algoFileType, FileInfo fileInfo, String name) {
        ClientAlgorithmFile file = new ClientAlgorithmFile(version.getInfo(), version.getId(), fileInfo.getName(), fileInfo.getPathAsArray(), algoFileType, false);
        return this.rename(file, name);
    }

    public boolean renameExecFile(AlgorithmVersionInfo version, String platformName, FileInfo fileInfo, String name) {
        ClientAlgorithmFile file = new ClientAlgorithmFile(version.getInfo(), version.getId(), platformName, fileInfo.getName(), fileInfo.getPathAsArray(), false);
        return this.rename(file, name);
    }

    private boolean rename(final ClientAlgorithmFile file, String name) {
        Window owner = this.getWindow();
        final String nameTrimmed = name.trim();
        if (!ClientUtilities.isValidFileName(nameTrimmed)) {
            StandardDialogs.showErrorDialog((Component)owner, (String)LNG.get((String)"GENERIC.title.error"), (String)LNG.get((String)"algomanager.error.invalid_filename"));
            return false;
        }
        String fileType = file.isDirectory() ? LNG.get((String)"algomanager.filetype.directory") : LNG.get((String)"algomanager.filetype.file");
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                file.rename(nameTrimmed);
            }
        };
        return task.execute(owner, "Renomear", MessageFormat.format(LNG.get((String)"algomanager.msg.rename_wait"), fileType));
    }

    private void startRenamingAction() {
        this.getTree().startEditingAtPath(this.getTree().getSelectionPath());
    }
}

