/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.event.EventListener;
import csbase.client.util.event.EventManager;
import csbase.client.util.event.IEvent;
import csbase.logic.SchedulerStateChangedEvent;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.awt.event.ActionEvent;

public class SchedulerSwitchAction
extends AbstractSimpleApplicationAction<Application> {
    private EventManager eventManager = new EventManager();
    private boolean blocked;

    public SchedulerSwitchAction(Application application) {
        super(application);
        this.setEnabled(User.getLoggedUser().isAdmin());
        this.registerListetener();
        this.updateState();
    }

    private void registerListetener() {
        MessageProxy.addListener(new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message aMessage : messages) {
                    SchedulerStateChangedEvent event = (SchedulerStateChangedEvent)aMessage.getBody();
                    SchedulerSwitchAction.this.setSchedulerBlocked(event.isBlocked());
                }
            }
        }, SchedulerStateChangedEvent.class);
    }

    public boolean isSchedulerBlocked() {
        return this.blocked;
    }

    public void addStateChangedListener(EventListener<StateChangedEvent> listener) {
        this.eventManager.addEventListener(listener, StateChangedEvent.class);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        final boolean newState = !this.blocked;
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                ClientRemoteLocator.schedulerService.setBlocked(newState);
            }
        };
        String title = ((Application)this.getApplication()).getString("task.scheduler.state.update.title");
        String msg = ((Application)this.getApplication()).getString("task.scheduler.state.update.message");
        task.execute(((Application)this.getApplication()).getApplicationFrame(), title, msg);
    }

    private void setSchedulerBlocked(boolean blocked) {
        this.blocked = blocked;
        this.eventManager.fireEvent(new StateChangedEvent(blocked));
    }

    private void updateState() {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.schedulerService.isBlocked());
            }
        };
        String title = ((Application)this.getApplication()).getString("task.scheduler.state.retrieve.title");
        String msg = ((Application)this.getApplication()).getString("task.scheduler.state.retrieve.message");
        if (task.execute(((Application)this.getApplication()).getApplicationFrame(), title, msg)) {
            this.setSchedulerBlocked((Boolean)task.getResult());
        }
    }

    public class StateChangedEvent
    implements IEvent {
        private final boolean blocked;

        private StateChangedEvent(boolean blocked) {
            this.blocked = blocked;
        }

        public boolean isSchedulerBlocked() {
            return this.blocked;
        }
    }
}

