/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.preferenceviewer.tree;

import csbase.client.applications.preferenceviewer.PreferencePanel;
import csbase.client.applications.preferenceviewer.PreferenceViewer;
import csbase.client.applications.preferenceviewer.tree.PreferenceTreeCellRenderer;
import csbase.client.applications.preferenceviewer.tree.PreferenceTreeModel;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.util.PreferenceEditorListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import tecgraf.javautils.gui.GBC;

public class PreferenceTreePanel
extends JPanel {
    private PreferencePanel preferencePanel;
    private PreferenceViewer app;
    private JTree tree;
    private PreferenceCategory lastSelected;
    private Map<PreferenceValue<?>, List<PreferenceEditorListener>> listeners = new HashMap();

    public PreferenceTreePanel(PreferencePanel preferencePanel, PreferenceViewer app) {
        super(new GridBagLayout());
        this.preferencePanel = preferencePanel;
        this.app = app;
        this.tree = this.createTree();
        this.add((Component)new JScrollPane(this.tree), new GBC(0, 0).both());
    }

    public void defaultSelection() {
        this.tree.setSelectionRow(0);
    }

    public void rebuildTree(PreferenceCategory newRoot) {
        this.tree.setModel(this.createTreeModel(newRoot));
        this.tree.setRootVisible(!newRoot.isRoot());
        this.defaultSelection();
    }

    public PreferenceCategory getLastSelected() {
        return this.lastSelected;
    }

    public void removeAllListeners() {
        PreferenceCategory allPrefs = PreferenceManager.getInstance().loadPreferences();
        for (PreferenceCategory pc : allPrefs.getCategories()) {
            this.removeListeners(pc);
        }
    }

    private void removeListeners(PreferenceCategory pc) {
        for (PreferenceValue<?> pv : pc.getPreferences(PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE)) {
            if (!this.listeners.containsKey(pv)) continue;
            for (PreferenceEditorListener l : this.listeners.get(pv)) {
                pv.getEditor().removeListener(l);
            }
        }
        for (PreferenceCategory child : pc.getCategories()) {
            this.removeListeners(child);
        }
    }

    private JTree createTree() {
        PreferenceManager pm = PreferenceManager.getInstance();
        PreferenceCategory rootPref = pm.loadPreferences();
        JTree tree = new JTree(this.createTreeModel(rootPref));
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "None");
        tree.setRowHeight(20);
        tree.setRootVisible(!rootPref.isRoot());
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JTree tree = (JTree)e.getSource();
                PreferenceCategory pc = (PreferenceCategory)tree.getLastSelectedPathComponent();
                if (pc != null) {
                    PreferenceTreePanel.this.preferencePanel.showPreferencePanel(pc);
                    tree.expandPath(tree.getSelectionPath());
                    PreferenceTreePanel.this.memorizeLastSelected(pc);
                }
            }
        });
        tree.setCellRenderer(new PreferenceTreeCellRenderer(this.preferencePanel, this.app));
        return tree;
    }

    private void memorizeLastSelected(final PreferenceCategory pc) {
        this.lastSelected = pc;
        PreferenceEditorListener l = new PreferenceEditorListener(){

            @Override
            public void action() {
                PreferenceTreePanel.this.preferencePanel.addModifiedCategory(pc);
                PreferenceTreePanel.this.repaint();
            }
        };
        for (PreferenceValue<?> pv : pc.getPreferences(PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE)) {
            if (this.listeners.containsKey(pv)) continue;
            pv.getEditor().addListener(l);
            ArrayList<2> editorListeners = new ArrayList<2>();
            editorListeners.add(l);
            this.listeners.put(pv, editorListeners);
        }
    }

    private TreeModel createTreeModel(PreferenceCategory pc) {
        List<String> order = this.app.getStringListSpecificProperty("tree.order");
        PreferenceTreeModel model = new PreferenceTreeModel(pc);
        model.setOrder(order);
        return model;
    }
}

