/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.menu;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.csvpanel.menu.CSVTablePopupMenu;
import csbase.client.util.csvpanel.table.CSVTable;
import csbase.client.util.csvpanel.table.CSVTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class RowHeaderPopupMenu
extends CSVTablePopupMenu {
    private JMenuItem addRowBeforeItem;
    private JMenuItem addRowAfterItem;
    private JMenuItem removeRowItem;
    private JMenuItem duplicateRowItem;

    public RowHeaderPopupMenu(CSVTable table) {
        super(table);
        this.createMenu();
    }

    private void createMenu() {
        String addRowBeforeLabel = this.getString("addRowBefore.item");
        this.addRowBeforeItem = new JMenuItem(addRowBeforeLabel, ApplicationImages.ICON_ROWINSERTBEFORE_16);
        this.addRowBeforeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVTableModel model = RowHeaderPopupMenu.this.table.getModel();
                model.addRow(RowHeaderPopupMenu.this.popupRow);
            }
        });
        this.add(this.addRowBeforeItem);
        String addRowAfterLabel = this.getString("addRowAfter.item");
        this.addRowAfterItem = new JMenuItem(addRowAfterLabel, ApplicationImages.ICON_ROWINSERTAFTER_16);
        this.addRowAfterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVTableModel model = RowHeaderPopupMenu.this.table.getModel();
                model.addRow(RowHeaderPopupMenu.this.popupRow + 1);
            }
        });
        this.add(this.addRowAfterItem);
        String removeRowLabel = this.getString("removeRow.item");
        this.removeRowItem = new JMenuItem(removeRowLabel, ApplicationImages.ICON_ROWDELETE_16);
        this.removeRowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVTableModel model = RowHeaderPopupMenu.this.table.getModel();
                model.removeRow(RowHeaderPopupMenu.this.popupRow);
            }
        });
        this.add(this.removeRowItem);
        String duplicateRowLabel = this.getString("duplicateRow.item");
        this.duplicateRowItem = new JMenuItem(duplicateRowLabel, ApplicationImages.ICON_ROWDUPLICATE_16);
        this.duplicateRowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVTableModel model = RowHeaderPopupMenu.this.table.getModel();
                model.duplicateRow(RowHeaderPopupMenu.this.popupRow);
            }
        });
        this.add(this.duplicateRowItem);
    }

    @Override
    protected boolean shouldBeShown() {
        return super.shouldBeShown() && this.table.isEditable();
    }

    @Override
    protected void updateItemStatus() {
        this.removeRowItem.setEnabled(this.table.getRowCount() > 1);
    }
}

