/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectInfoData;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.exception.BugException;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;
import csbase.remote.ProjectServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class FillProjectsTableUserTask
extends ProjectsManagerTask<ProjectInfoData> {
    private boolean loadOccupiedSpace;
    private List<UserProjectInfo> failedProjects = new ArrayList<UserProjectInfo>();

    public FillProjectsTableUserTask(ProjectsManager projectsManager, boolean loadOccupiedSpace) {
        super(projectsManager);
        this.loadOccupiedSpace = loadOccupiedSpace;
    }

    protected void performTask() throws Exception {
        List<ProjectsManagerData> projectsData = this.getProjectsData();
        ProjectInfoData pid = new ProjectInfoData(projectsData, this.failedProjects);
        this.setResult(pid);
    }

    private List<ProjectsManagerData> getProjectsData() throws Exception {
        ArrayList<ProjectsManagerData> projectList = new ArrayList<ProjectsManagerData>();
        this.getProjectsWhereUserIsOwner(projectList);
        this.getProjectsWhereUserIsNotOwner(projectList);
        return projectList;
    }

    private void getProjectsWhereUserIsOwner(List<ProjectsManagerData> projectList) throws RemoteException, Exception {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        DiskUsageServiceInterface dus = ClientRemoteLocator.diskUsageService;
        ProjectsManager projectsManager = this.getProjectsManager();
        User user = projectsManager.getUser();
        Object ownerId = user.getId();
        List projects = psi.getProjectsFromUser(ownerId);
        if (projects == null) {
            return;
        }
        for (UserProjectInfo prj : projects) {
            Object projectId = prj.getProjectId();
            ProjectAdminInfo projectAdminInfo = psi.getProjectAdminInfo(projectId);
            if (projectAdminInfo != null && !projectAdminInfo.isUnlockedWithAreaAllocated()) continue;
            try {
                CommonClientProject ccp = psi.openProject(projectId, false);
                long allocatedSpace = ccp.getLockingAreaSize();
                ProjectSpaceAllocation psa = ProjectSpaceAllocation.getItemFromSpace(allocatedSpace);
                if (psa != ProjectSpaceAllocation.NO_ALLOCATION && psa != ProjectSpaceAllocation.ALLOCATED) continue;
                String userId = (String)ccp.getUserId();
                String name = ccp.getName();
                ProjectsManagerData pmd = new ProjectsManagerData(ccp.getId(), ccp.getName(), ccp.getUserId());
                pmd.setOwnerName(User.getName((Object)userId));
                pmd.setProjectSpaceAllocation(psa);
                if (psa == ProjectSpaceAllocation.ALLOCATED) {
                    pmd.setAllocatedSpace(ccp.getLockingAreaSize());
                }
                pmd.setProjectDescription(ccp.getDescription());
                pmd.setCreationDate(ccp.getCreationDate());
                pmd.setServerOwnerName(ccp.getOwnerServerName());
                pmd.setLocationInServer(ccp.getLocationInServer());
                pmd.setModificationDate(ccp.getLastModificationDate());
                if (this.loadOccupiedSpace) {
                    pmd.setOccupiedSpace(dus.getUsedSpaceForProjectMb((Object)userId, name));
                } else {
                    pmd.setOccupiedSpace(-1.0);
                }
                try {
                    pmd.setSharingType(ccp.getSharingType());
                }
                catch (IllegalStateException ise) {
                    ccp.close(false);
                    continue;
                }
                pmd.setUsers(ccp.getUsersRO(), ccp.getUsersRW());
                ccp.close(false);
                projectList.add(pmd);
            }
            catch (BugException be) {
                this.failedProjects.add(prj);
            }
        }
    }

    private void getProjectsWhereUserIsNotOwner(List<ProjectsManagerData> projectList) throws RemoteException, Exception {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        DiskUsageServiceInterface dus = ClientRemoteLocator.diskUsageService;
        ProjectsManager projectsManager = this.getProjectsManager();
        User currentUser = projectsManager.getUser();
        List usrPrjInf = psi.getProjectsSharedWithUser(currentUser.getId());
        for (UserProjectInfo upi : usrPrjInf) {
            try {
                long allocatedSpace;
                ProjectSpaceAllocation psa;
                CommonClientProject ccp = psi.openProject(upi.getProjectId(), false);
                if (ccp.isPublic() && FillProjectsTableUserTask.checkProjectAlreadyInserted(projectList, upi.getOwnerId(), upi.getProjectName()) || (psa = ProjectSpaceAllocation.getItemFromSpace(allocatedSpace = ccp.getLockingAreaSize())) != ProjectSpaceAllocation.NO_ALLOCATION && psa != ProjectSpaceAllocation.ALLOCATED) continue;
                ProjectsManagerData pmd = new ProjectsManagerData(ccp.getId(), ccp.getName(), ccp.getUserId());
                pmd.setOwnerName(User.getName((Object)ccp.getUserId()));
                pmd.setProjectSpaceAllocation(psa);
                pmd.setProjectDescription(ccp.getDescription());
                pmd.setCreationDate(ccp.getCreationDate());
                pmd.setServerOwnerName(ccp.getOwnerServerName());
                pmd.setLocationInServer(ccp.getLocationInServer());
                pmd.setModificationDate(ccp.getLastModificationDate());
                if (this.loadOccupiedSpace) {
                    pmd.setOccupiedSpace(dus.getUsedSpaceForProjectMb(ccp.getUserId(), ccp.getName()));
                } else {
                    pmd.setOccupiedSpace(-1.0);
                }
                pmd.setSharingType(ccp.getSharingType());
                pmd.setUsers(ccp.getUsersRO(), ccp.getUsersRW());
                ccp.close(false);
                projectList.add(pmd);
            }
            catch (BugException be) {
                this.failedProjects.add(upi);
            }
        }
    }

    private static boolean checkProjectAlreadyInserted(List<ProjectsManagerData> projectList, Object userId, String projectName) {
        for (ProjectsManagerData pmd : projectList) {
            if (!pmd.getProjectName().equals(projectName) || !pmd.getOwnerId().equals(userId)) continue;
            return true;
        }
        return false;
    }
}

