/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.openbus;

import csbase.client.openbus.OpenBusEventHandler;

public enum OpenBusStandardEvents {
    PRJ_OPEN_REQ,
    PRJ_OPEN_SUCCESS_RSP,
    PRJ_OPEN_FAILED_RSP,
    PRJ_CLOSE_REQ,
    PRJ_CLOSE_RSP,
    PRJ_CLOSE_INFO,
    PRJ_OPEN_INFO,
    APP_EXECUTION_REQ,
    APP_EXECUTION_SUCCESS_RSP,
    APP_EXECUTION_FAILURE_RSP,
    DSKLAUNCHER_START_INFO,
    DSKLAUNCHER_END_INFO,
    DESKTOP_VISIBILITY_REQ,
    DESKTOP_VISIBILITY_INFO,
    DESKTOP_START_INFO,
    DESKTOP_SHUTDOWN_REQ,
    DESKTOP_END_INFO;


    public final boolean isMyType(String type) {
        String myType;
        if (type == null) {
            return false;
        }
        String trimmedType = type.trim();
        return trimmedType.equals(myType = this.name());
    }

    public final boolean sendEvent(OpenBusEventHandler eventHandler, String destId, Object value) {
        String sourceId = eventHandler.getClientInstanceId();
        String type = this.name();
        if (value == null) {
            return eventHandler.sendEventWithNoValue(sourceId, destId, type);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return eventHandler.sendEventWithStringValue(sourceId, destId, type, stringValue);
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return eventHandler.sendEventWithBooleanValue(sourceId, destId, type, booleanValue);
        }
        String className = ((Object)((Object)this)).getClass().getName();
        String typeName = value.getClass().getName();
        System.out.println("!!! FALHA DE TIPO: " + className + " / " + typeName);
        return false;
    }
}

