/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeImportThread;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeType;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.io.File;

public class ExchangeImport
extends Exchange {
    @Override
    protected ExchangeImportThread createThread() {
        return new ExchangeImportThread(this);
    }

    public final String toString() {
        ClientProjectFile remoteFile = this.getRemoteFile();
        File localFile = this.getLocalFile();
        if (remoteFile != null) {
            return localFile.getAbsolutePath() + " \u2192 " + remoteFile.getName();
        }
        return "";
    }

    public ExchangeImport(ExchangeMode transferMode, BlockSize blockSize, File localFile, ClientProjectFile remoteFile, ClientProjectFile remoteDir, CommonClientProject project) {
        super(ExchangeType.IMPORT, transferMode, blockSize, localFile, remoteFile, remoteDir, ExchangeImport.getLength(localFile), project);
    }

    public static long getLength(File file) {
        long lenght = 0L;
        if (file.isDirectory()) {
            lenght += file.length();
            for (File child : file.listFiles()) {
                lenght += ExchangeImport.getLength(child);
            }
        } else {
            lenght = file.length();
        }
        return lenght;
    }
}

