/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow.tree;

import java.util.ArrayList;
import java.util.Stack;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ParameterSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel model;

    public ParameterSelectionModel(TreeModel model) {
        this.model = model;
        this.setSelectionMode(4);
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        TreePath path;
        int i;
        for (i = 0; i < paths.length; ++i) {
            path = paths[i];
            TreePath[] selectionPaths = this.getSelectionPaths();
            if (selectionPaths == null) break;
            ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
            for (int j = 0; j < selectionPaths.length; ++j) {
                TreePath selectedPath = selectionPaths[j];
                if (!path.isDescendant(selectedPath)) continue;
                toBeRemoved.add(selectedPath);
            }
            super.removeSelectionPaths(toBeRemoved.toArray(new TreePath[toBeRemoved.size()]));
        }
        for (i = 0; i < paths.length; ++i) {
            path = paths[i];
            TreePath temp = null;
            while (this.areSiblingsSelected(path)) {
                temp = path;
                if (path.getParentPath() == null) break;
                path = path.getParentPath();
            }
            if (temp != null) {
                if (temp.getParentPath() != null) {
                    this.addSelectionPath(temp.getParentPath());
                    continue;
                }
                TreePath[] selectionPaths = this.getSelectionPaths();
                if (selectionPaths != null) {
                    this.removeSelectionPaths(selectionPaths);
                }
                super.addSelectionPaths(new TreePath[]{temp});
                continue;
            }
            super.addSelectionPaths(new TreePath[]{path});
        }
    }

    public boolean isPathSelected(TreePath path, boolean dig) {
        TreePath selectedPath;
        if (!dig) {
            return super.isPathSelected(path);
        }
        for (selectedPath = path; selectedPath != null && !super.isPathSelected(selectedPath); selectedPath = selectedPath.getParentPath()) {
        }
        return selectedPath != null;
    }

    private boolean areSiblingsSelected(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        Object parentNode = parent.getLastPathComponent();
        int childCount = this.model.getChildCount(parentNode);
        for (int i = 0; i < childCount; ++i) {
            Object childNode = this.model.getChild(parentNode, i);
            if (childNode == node || this.isPathSelected(parent.pathByAddingChild(childNode))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            if (path.getPathCount() == 1) {
                super.removeSelectionPaths(new TreePath[]{path});
                continue;
            }
            this.toggleRemoveSelection(path);
        }
    }

    private void toggleRemoveSelection(TreePath path) {
        TreePath parent;
        Stack<TreePath> stack = new Stack<TreePath>();
        for (parent = path.getParentPath(); parent != null && !this.isPathSelected(parent); parent = parent.getParentPath()) {
            stack.push(parent);
        }
        if (parent != null) {
            stack.push(parent);
        } else {
            super.removeSelectionPaths(new TreePath[]{path});
            return;
        }
        while (!stack.isEmpty()) {
            TreePath temp = (TreePath)stack.pop();
            TreePath peekPath = stack.isEmpty() ? path : (TreePath)stack.peek();
            Object node = temp.getLastPathComponent();
            Object peekNode = peekPath.getLastPathComponent();
            int childCount = this.model.getChildCount(node);
            for (int i = 0; i < childCount; ++i) {
                Object childNode = this.model.getChild(node, i);
                if (childNode == peekNode) continue;
                super.addSelectionPaths(new TreePath[]{temp.pathByAddingChild(childNode)});
            }
        }
        super.removeSelectionPaths(new TreePath[]{parent});
    }
}

