/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.xmlviewer.actions.core;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.xmlviewer.XMLViewer;
import csbase.client.applications.xmlviewer.actions.core.XMLViewerAction;
import csbase.client.desktop.Task;
import csbase.client.util.xmlpanel.XMLPanelStyleInterface;
import csbase.exception.PermissionException;
import csbase.logic.ClientFile;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.xml.sax.SAXParseException;
import tecgraf.javautils.gui.StatusBar;

public abstract class XMLViewerAbstractOpenAction
extends XMLViewerAction {
    protected abstract ClientFile getFileForOpen() throws Exception;

    @Override
    public final void actionDone(JComponent cmp) throws Exception {
        ClientFile file = this.getFileForOpen();
        if (file == null) {
            return;
        }
        this.openFileInTask(file);
        XMLViewer application = (XMLViewer)this.getApplication();
        String type = file.getType();
        XMLPanelStyleInterface style = application.getTipicalStyle(type);
        application.setStyle(style);
    }

    private void _openFileInTask(ClientFile file) {
        XMLViewer application = (XMLViewer)this.getApplication();
        try {
            application.openXML(file);
        }
        catch (Exception e) {
            application.showExceptionStack(e);
            return;
        }
    }

    private void openFileInTask(final ClientFile file) {
        final XMLViewer application = (XMLViewer)this.getApplication();
        Task<Void> task = new Task<Void>(){

            public void performTask() throws Exception {
                application.openXML(file);
            }

            @Override
            protected void handleError(Exception exception) {
                String msg = exception.getMessage();
                if (exception instanceof IOException) {
                    String err = XMLViewerAbstractOpenAction.this.getString("XMLViewerAbstractOpenAction.open.xml.io.failure", new Object[0]);
                    application.showError(err + "\n\u2022" + msg);
                    return;
                }
                if (exception instanceof SAXParseException) {
                    String err = XMLViewerAbstractOpenAction.this.getString("XMLViewerAbstractOpenAction.open.xml.syntax.failure", new Object[0]);
                    application.showError(err + "\n\u2022" + msg);
                    return;
                }
                if (exception instanceof PermissionException) {
                    String err = XMLViewerAbstractOpenAction.this.getString("XMLViewerAbstractOpenAction.open.xml.permission.failure", new Object[0]);
                    application.showError(err);
                    return;
                }
                super.handleError(exception);
            }
        };
        String msg = this.getString("XMLViewerAbstractOpenAction.open.xml.message", new Object[0]);
        ImageIcon icon = ApplicationImages.ICON_ANIMATEDENGINES_32;
        String title = application.getName();
        ApplicationFrame frame = application.getApplicationFrame();
        boolean ok = task.execute(frame, title, msg, icon);
        StatusBar statusBar = frame.getStatusBar();
        if (task.wasCancelled()) {
            String cancelMsg = this.getString("XMLViewerAbstractOpenAction.open.xml.cancel", new Object[0]);
            statusBar.setWarning(cancelMsg, 5);
            return;
        }
        if (!ok) {
            String err = this.getString("XMLViewerAbstractOpenAction.open.xml.failure", new Object[0]);
            statusBar.setError(err, 5);
            application.resetFile();
            return;
        }
        String okMsg = this.getString("XMLViewerAbstractOpenAction.open.xml.success", new Object[0]);
        statusBar.setInfo(okMsg, 5);
    }

    public XMLViewerAbstractOpenAction(XMLViewer application, ImageIcon icon) {
        super(application, icon);
    }
}

