/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.List;
import java.util.Set;

class RemoveUsersTask
extends ProjectsManagerTask<Void> {
    private final List<ProjectsManagerData> projects;
    private final Set<Object> userIds;

    public RemoveUsersTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, Set<Object> userIds) {
        super(projectsManager);
        this.projects = projects;
        this.userIds = userIds;
    }

    protected void performTask() throws Exception {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        for (ProjectsManagerData pmd : this.projects) {
            CommonClientProject ccp = psi.openProject(pmd.getProjectId(), false);
            Set<Object> usersRO = pmd.getUsersRO();
            Set<Object> usersRW = pmd.getUsersRW();
            usersRO.removeAll(this.userIds);
            usersRW.removeAll(this.userIds);
            ccp.updateUsersRO(usersRO);
            ccp.updateUsersRW(usersRW);
        }
    }
}

