/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.algorithms.commands.CommandPersistenceListener;
import csbase.logic.Notification;
import csbase.logic.NotificationHandler;
import csbase.logic.algorithms.commands.CommandPersistenceNotification;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class CommandPersistenceCommandNotificationHandler
implements NotificationHandler {
    private static CommandPersistenceCommandNotificationHandler instance = new CommandPersistenceCommandNotificationHandler();
    private List<CommandPersistenceListener> listeners = new LinkedList<CommandPersistenceListener>();
    private Executor executor = Executors.newSingleThreadExecutor();

    private CommandPersistenceCommandNotificationHandler() {
    }

    public static CommandPersistenceCommandNotificationHandler getInstance() {
        return instance;
    }

    public void addListener(CommandPersistenceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public boolean removeListener(CommandPersistenceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.remove(listener);
    }

    public void gotNotification(Notification data) {
        if (!(data instanceof CommandPersistenceNotification)) {
            return;
        }
        final CommandPersistenceNotification pData = (CommandPersistenceNotification)data;
        Runnable doRun = new Runnable(){

            @Override
            public void run() {
                Object projectId = pData.getProjectId();
                String commandId = pData.getCommandId();
                switch (pData.getType()) {
                    case REMOVED: {
                        for (CommandPersistenceListener listener : CommandPersistenceCommandNotificationHandler.this.listeners) {
                            listener.commandWasRemoved(projectId, commandId);
                        }
                        break;
                    }
                    case SAVED: {
                        for (CommandPersistenceListener listener : CommandPersistenceCommandNotificationHandler.this.listeners) {
                            listener.commandWasSaved(projectId, commandId);
                        }
                        break;
                    }
                    case UPDATED: {
                        for (CommandPersistenceListener listener : CommandPersistenceCommandNotificationHandler.this.listeners) {
                            listener.commandWasUpdated(projectId, commandId);
                        }
                        break;
                    }
                    default: {
                        String errorMessage = String.format("Notifica\u00e7\u00e3o de tipo desconhecido.\nProjeto: %s.\nComando: %s.\nTipo de notifica\u00e7\u00e3o: %s.\n", projectId, commandId, pData.getType());
                        throw new IllegalArgumentException(errorMessage);
                    }
                }
            }
        };
        this.executor.execute(doRun);
    }
}

