/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.xmlpanel.xmlsearchpanel;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.xmlpanel.XMLAbstractPanel;
import csbase.client.util.xmlpanel.XMLPanelNodeSelectionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.w3c.dom.Node;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class XMLSearchPanel
extends XMLAbstractPanel {
    private final List<XMLPanelNodeSelectionListener> listeners = new ArrayList<XMLPanelNodeSelectionListener>();
    private final JTextField searchTextField = new JTextField();
    private final JCheckBox caseToggle = new JCheckBox();
    private final JButton nextButton = new JButton();
    private final JButton prevButton = new JButton();
    private final JLabel findLabel = new JLabel();
    private final JButton closeButton = new JButton();

    protected void goToNodeFromCurrent(Direction direction) {
        Node searchNode = this.getNode();
        if (searchNode == null) {
            return;
        }
        Node nextNode = this.getNextNode(direction, searchNode);
        Node findNode = this.findNode(direction, nextNode);
        if (findNode == null) {
            return;
        }
        this.fireSearchSelection(findNode);
    }

    private Node findNode(Direction direction, Node searchNode) {
        if (searchNode == null) {
            return null;
        }
        if (this.isSearchedNode(searchNode)) {
            return searchNode;
        }
        Node nextNode = this.getNextNode(direction, searchNode);
        while (nextNode != null) {
            if (this.isSearchedNode(nextNode)) {
                return nextNode;
            }
            nextNode = this.getNextNode(direction, nextNode);
        }
        return null;
    }

    private boolean isSearchedNode(Node searchNode) {
        String searchText = this.getSearchText();
        String searchName = searchNode.getNodeName();
        boolean found = this.caseToggle.isSelected() ? searchName.equals(searchText) : searchName.equalsIgnoreCase(searchText);
        return found;
    }

    private Node getNextNode(Direction direction, Node searchNode) {
        if (searchNode == null) {
            return null;
        }
        Node parent = searchNode.getParentNode();
        switch (direction) {
            case FWD: {
                Node fwdChild = searchNode.getFirstChild();
                if (fwdChild != null) {
                    return fwdChild;
                }
                fwdChild = searchNode.getNextSibling();
                if (fwdChild != null) {
                    return fwdChild;
                }
                if (parent == null) {
                    return null;
                }
                fwdChild = parent.getNextSibling();
                return fwdChild;
            }
            case BCK: {
                Node bckChild = searchNode.getPreviousSibling();
                if (bckChild != null) {
                    Node tryNode = bckChild.getLastChild();
                    if (tryNode != null) {
                        return tryNode;
                    }
                    return bckChild;
                }
                if (parent == null) {
                    return null;
                }
                return parent;
            }
        }
        return null;
    }

    protected void findNext() {
        this.goToNodeFromCurrent(Direction.FWD);
    }

    protected void findPrevious() {
        this.goToNodeFromCurrent(Direction.BCK);
    }

    private String getSearchText() {
        String findTagText = this.searchTextField.getText();
        if (findTagText == null) {
            return null;
        }
        if ((findTagText = findTagText.trim()).isEmpty()) {
            return null;
        }
        return findTagText;
    }

    private void fireSearchSelection(Node node) {
        for (XMLPanelNodeSelectionListener listener : this.listeners) {
            listener.nodeSelected(node);
        }
    }

    @Override
    public void setNode(Node node) {
        this.internalSetNode(node);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.setNode(null);
        } else {
            this.searchTextField.setText(null);
            this.searchTextField.requestFocus();
        }
        super.setVisible(visible);
    }

    public XMLSearchPanel() {
        this.initComponents();
        this.mountPanel();
        this.adjustActions();
    }

    private void adjustActions() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap aMap = this.getActionMap();
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLSearchPanel.this.findNext();
            }
        };
        inputMap.put(enterKey, enterKey.toString());
        aMap.put(enterKey.toString(), enterAction);
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLSearchPanel.this.setVisible(false);
            }
        };
        inputMap.put(escKey, escKey.toString());
        aMap.put(escKey.toString(), escAction);
    }

    private void mountPanel() {
        int i = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.closeButton, new GBC(i++, 0));
        this.add((Component)new JLabel("    "), new GBC(i++, 0));
        this.add((Component)this.findLabel, new GBC(i++, 0));
        this.add((Component)this.searchTextField, new GBC(i++, 0).horizontal());
        this.add((Component)this.prevButton, new GBC(i++, 0));
        this.add((Component)this.nextButton, new GBC(i++, 0));
        this.add((Component)new JPanel(), new GBC(i++, 0).horizontal());
        this.add((Component)this.caseToggle, new GBC(i++, 0));
    }

    private void initComponents() {
        this.findLabel.setText(this.getString("find.label"));
        this.caseToggle.setText(this.getString("case.label"));
        Dimension minSize = new Dimension(50, 10);
        this.searchTextField.setMinimumSize(minSize);
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLSearchPanel.this.setVisible(false);
            }
        });
        GUIUtils.trimImageButton((AbstractButton)this.closeButton);
        this.searchTextField.setColumns(20);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLSearchPanel.this.findNext();
            }
        });
        this.nextButton.setIcon(ApplicationImages.ICON_FIND_NEXT_16);
        GUIUtils.trimImageButton((AbstractButton)this.nextButton);
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLSearchPanel.this.findPrevious();
            }
        });
        this.prevButton.setIcon(ApplicationImages.ICON_FIND_PREV_16);
        GUIUtils.trimImageButton((AbstractButton)this.prevButton);
    }

    public void addSelectionListener(XMLPanelNodeSelectionListener listener) {
        this.listeners.add(listener);
    }

    static enum Direction {
        FWD,
        BCK;

    }
}

