/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.NewCommandViewUtils;
import csbase.client.algorithms.commands.view.AlgorithmCommandViewFactory;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.actions.AbstractCommandsAction;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.awt.event.ActionEvent;

public class ShowCommandLogAction
extends AbstractCommandsAction {
    public ShowCommandLogAction(CommandsMonitor application) {
        super(application, false, ApplicationImages.ICON_VIEWLOG_16);
    }

    @Override
    protected boolean accept(CommandInfo command) {
        DesktopFrame desktop = DesktopFrame.getInstance();
        boolean hasOpenProjects = desktop.getProject() != null;
        return hasOpenProjects && command.getStatus() != CommandStatus.SCHEDULED && command.getStatus() != CommandStatus.SYSTEM_FAILURE;
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        ApplicationFrame owner = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
        CommandInfo command = this.getSelectedCommand();
        if (NewCommandViewUtils.useNewVersion()) {
            CommandViewFactory.showCommandView(command, owner, NewCommandViewUtils.getNewTabType(TabType.LOG));
        } else {
            AlgorithmCommandViewFactory.showView(owner, command, TabType.LOG);
        }
    }
}

