/*
 * AlgoEvent.java
 * 
 * $Author: pizzol $ $Revision: 119881 $ - $Date: 2004-12-10 10:40:18 -0200
 * (Fri, 10 Dec 2004) $
 */
package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * A classe <code>AlgoEvent</code> representa um evento ocorrido no servio de
 * algoritmos. Os eventos podem ser de criao, modificao ou remoo de algum
 * objeto.
 * 
 * @author Leonardo Abreu de Barros
 * @version $Revision: 119881 $
 */
public class AlgoEvent extends RemoteEvent {
  /** A ao de criao de um objeto no provedor. */
  public static final int CREATE = 1;
  /** A ao de modificao de um objeto no provedor. */
  public static final int MODIFY = 2;
  /** A ao de remoo de um objeto no provedor. */
  public static final int DELETE = 3;

  /** Indica qual foi a ao ocorrida no provedor. */
  public int type;
  /** Indica o objeto resultante da ao ocorrida. */
  public Object item;

  /**
   * Cria o objeto que representa um evento ocorrido no servio de algoritmos.
   * 
   * @param type a ao ocorrida
   * @param item o objeto resultante da ao
   */
  public AlgoEvent(int type, Object item) {
    this.type = type;
    this.item = item;
  }
}
