/*
 * CommandLostNotificationData.java
 * 
 * $Author: cassino $ $Date: 2011-03-04 15:15:45 -0300 (Fri, 04 Mar 2011) $
 * $Revision: 116055 $
 */

package csbase.logic;

/**
 * Classe que representa os dados de mensagem de comando perdido em um SGA.<br>
 * Isso acontece, por exemplo, na seguinte situao:<br>
 * Digamos que o SGAD seja desligado. Quando reiniciado, ele verifica o contedo
 * de sua tabela de algoritmos em execuo [que  persistida]. Havendo entradas,
 * verifica-se suas situaes. Se um comando no estiver mais executando e no
 * tiver terminado da forma usual, o SGAD no saber o que fazer, notificando
 * ento uma perda de comando.
 */
public class CommandLostNotification extends
  DefaultCommandFinishedNotification {

  /**
   * Constri o evento de perda de comando sem dados de tempo.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param commandId identificador do comando.
   * @param cmdDesc descrio do comando.
   * @param tip Dica para auxiliar a identificao do algoritmo do comando.
   * @param startTime Hora de incio
   * @param execHost Servidor de execuo.
   * @param projectId identificador do projeto
   * @param finalizationInfo Informaes sobre a finalizao do comando.
   */
  public CommandLostNotification(String sender, Object commandId,
    String cmdDesc, String tip, long startTime, String execHost,
    Object projectId, CommandFinalizationInfo finalizationInfo) {
    super(sender, commandId, cmdDesc, tip, startTime, execHost, projectId,
      finalizationInfo);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getStatusString() {
    return "LOST";
  }
}
