package csbase.logic;

import java.util.Comparator;

/**
 * Implementao do comparador de ClientProjectFile por tipo de arquivo.
 * 
 * Ordenao: diretrio pai quando existir (..), seguido dos diretrios
 * ordenados alfabeticamente, seguidos dos tipos de arquivos ordenados
 * alfabeticamente.
 * 
 * @author tatimf
 */
public class FileTypeComparator implements Comparator<ClientProjectFile> {

  /**
   * {@inheritDoc}
   */
  @Override
  public int compare(ClientProjectFile file1, ClientProjectFile file2) {
    if (file1.isDirectory()) {
      if (file2.isDirectory()) {
        return file1.getName().compareToIgnoreCase(file2.getName());
      }
      else {
        return -1;
      }
    }
    if (file2.isDirectory()) {
      return 1;
    }
    else {
      String typeFile1 =
        ProjectFileType.getFileType(file1.getType()).getDescription();
      String typeFile2 =
        ProjectFileType.getFileType(file2.getType()).getDescription();

      return typeFile1.compareToIgnoreCase(typeFile2);
    }
  }
}
