package csbase.logic.algorithms;

/**
 * Representa uma varivel de ambiente utilizada na linha de comando.
 * 
 * @author isabella
 */
/**
 * 
 * 
 * @author Tecgraf
 */
public enum EnvironmentVariable {

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho do diretrio de execuo do algoritmo.
   */
  EXECUTION_DIR,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho do diretrio de binrios do algoritmo.
   */
  BINARY_DIR,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho do diretrio da sandbox de execuo do algoritmo.
   */
  SANDBOX_DIR,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho do diretrio de projeto do comando.
   */
  PROJECT_DIR,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho para os arquivos de entrada do comando.
   */
  INPUT_FILES,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho para os arquivos de sada do comando.
   */
  OUTPUT_FILES,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho para o arquivo de log que armazena o n do fluxo responsvel pelo
   * erro de execuo (se houver).
   */
  FLOW_GUILTY_NODE_ID_LOG,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o identificador do n do fluxo.
   */
  FLOW_NODE_ID,

  /**
   * Varivel de ambiente definida pelo SGA que armazena o caminho do diretrio
   * da sandbox de execuo do fluxo.
   */
  FLOW_SANDBOX_DIR,

  /**
   * Varivel de ambiente definida na linha de comando do algoritmo que armazena
   * o caminho para o arquivo de log do algoritmo.
   */
  LOG_FILE;

  /**
   * Prefixo das varivel definida pelo CSBASE.
   */
  private static final String CSBASE_VAR_PREFIX = "CSBASE_";

  /**
   * Retorna o nome da varivel de ambiente.
   * 
   * @return O nome da varivel.
   */
  public String getName() {
    return toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    switch (this) {
      case BINARY_DIR:
        return CSBASE_VAR_PREFIX + "BIN_DIR";
      case EXECUTION_DIR:
        return CSBASE_VAR_PREFIX + "EXECUTION_DIR";
      case SANDBOX_DIR:
        return CSBASE_VAR_PREFIX + "SANDBOX_DIR";
      case PROJECT_DIR:
        return CSBASE_VAR_PREFIX + "PROJ_DIR";
      case INPUT_FILES:
        return CSBASE_VAR_PREFIX + "INPUT_FILES";
      case OUTPUT_FILES:
        return CSBASE_VAR_PREFIX + "OUTPUT_FILES";
      case FLOW_GUILTY_NODE_ID_LOG:
        return CSBASE_VAR_PREFIX + "FLOW_GUILTY_NODE_ID_LOG";
      case FLOW_NODE_ID:
        return CSBASE_VAR_PREFIX + "FLOW_NODE_ID";
      case FLOW_SANDBOX_DIR:
        return CSBASE_VAR_PREFIX + "FLOW_SANDBOX_DIR";
      case LOG_FILE:
        return CSBASE_VAR_PREFIX + "LOG_FILE";
      default:
        return "";
    }
  }
}
