package csbase.logic.algorithms.parsers;

import java.io.Serializable;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;

/**
 * Representa uma fbrica de um tipo de parmetro do sistema que pode ser
 * carregado dinamicamente.
 */
public interface ParameterFactory extends Serializable {

  /**
   * Cria uma instncia do parmetro a partir das informaes do parser do
   * configurador de algoritmos.
   * 
   * @param parser Parser do configurador.
   * @param commandLinePattern Padro de linha de comando do algoritmo.
   * @param group grupo em criao.
   * @return Uma instncia do parmetro criado.
   * @throws ParseException Caso no seja possvel criar o parmetro com as
   *         informaes do parser.
   */
  public abstract Parameter<?> createParameter(XmlParser parser,
    String commandLinePattern, ParameterGroup group) throws ParseException;

}