/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.core.io.FileUtils;

public class Version
implements Comparable<Version>,
Serializable {
    private static final String VERSION_DATE_FORMAT = "%s/%s/%s";
    private static final String NO_DATE_STR = String.format("%s/%s/%s", "??", "??", "????");
    private static final String VERSION_ID_FORMAT = "v%s.%s.%s";
    public static final String BAD_VERSION_STR = String.format("v%s.%s.%s", "?", "??", "??");
    private static final String VERSION_ID_REGEX = "\\p{Upper}+_v(\\d)_(\\d{2})_(\\d{2})_(\\d{4})_(\\d{2})_(\\d{2})";
    private static final String PROPERTY_VERSION = "version";
    private static final String VERSION_FILE = "/csbase/resources/version.properties";
    private static final Version instance = new Version();
    private String name;
    protected String version;
    protected String releaseDate;
    protected int major;
    protected int minor;
    protected int patch;
    protected int day;
    protected int month;
    protected int year;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = Version.class.getResourceAsStream(VERSION_FILE);
            if (inputStream == null) {
                throw new FileNotFoundException(MessageFormat.format("O arquivo {0} n\u00e3o foi encontrado.", VERSION_FILE));
            }
            properties.load(inputStream);
            this.name = properties.getProperty(PROPERTY_VERSION);
        }
        catch (IOException e) {
            this.name = String.valueOf(System.currentTimeMillis());
            e.printStackTrace();
        }
        finally {
            FileUtils.close((Closeable)inputStream);
        }
        if (!this.splitVersionId()) {
            this.version = null;
            this.releaseDate = null;
        }
    }

    protected Version(String prjVersionID) {
        this.name = prjVersionID;
        if (!this.splitVersionId()) {
            this.version = null;
            this.releaseDate = null;
        }
    }

    protected boolean splitVersionId() {
        if (this.name == null) {
            return false;
        }
        Matcher matcher = Pattern.compile(VERSION_ID_REGEX).matcher(this.name);
        if (!matcher.matches()) {
            return false;
        }
        int i = 1;
        String strMajor = matcher.group(i++);
        String strMinor = matcher.group(i++);
        String strPatch = matcher.group(i++);
        if (strMajor == null || strMinor == null || strPatch == null) {
            return false;
        }
        this.major = Integer.parseInt(strMajor);
        this.minor = Integer.parseInt(strMinor);
        this.patch = Integer.parseInt(strPatch);
        this.version = String.format(VERSION_ID_FORMAT, this.major, this.minor, this.patch);
        String strYear = matcher.group(i++);
        String strMonth = matcher.group(i++);
        String strDay = matcher.group(i++);
        if (strYear == null || strMonth == null || strDay == null) {
            return false;
        }
        this.day = Integer.parseInt(strDay);
        this.month = Integer.parseInt(strMonth);
        this.year = Integer.parseInt(strYear);
        this.releaseDate = String.format(VERSION_DATE_FORMAT, this.day, this.month, this.year);
        return true;
    }

    public static Version getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public final String getVersion() {
        return this.version == null ? BAD_VERSION_STR : this.version;
    }

    public final int getMajorVersion() {
        return this.version == null ? -1 : this.major;
    }

    public final int getMinorVersion() {
        return this.version == null ? -1 : this.minor;
    }

    public final int getPatchVersion() {
        return this.version == null ? -1 : this.patch;
    }

    public final String getReleaseDate() {
        return this.releaseDate == null ? NO_DATE_STR : this.releaseDate;
    }

    public final int getReleaseDay() {
        return this.releaseDate == null ? -1 : this.day;
    }

    public final int getReleaseMonth() {
        return this.releaseDate == null ? -1 : this.month;
    }

    public final int getReleaseYear() {
        return this.releaseDate == null ? -1 : this.year;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public boolean precedes(Version other) {
        return this.compareTo(other) == -1;
    }

    public boolean succeeds(Version other) {
        return this.compareTo(other) == 1;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Version o) {
        if (this.version == null) {
            return o.version == null ? 0 : 1;
        }
        if (o.version == null) {
            return -1;
        }
        if (this.major == o.major) {
            if (this.minor == o.minor) {
                if (this.patch == o.patch) {
                    return this.compareDate(o);
                }
                return this.patch > o.patch ? 1 : -1;
            }
            return this.minor > o.minor ? 1 : -1;
        }
        return this.major > o.major ? 1 : -1;
    }

    public int compareDate(Version o) {
        if (this.year == o.year) {
            if (this.month == o.month) {
                if (this.day == o.day) {
                    return 0;
                }
                return this.day > o.day ? 1 : -1;
            }
            return this.month > o.month ? 1 : -1;
        }
        return this.year > o.year ? 1 : -1;
    }

    public static void main(String[] args) {
        Version v1 = new Version("MLM_v1_06_04_2008_08_13");
        Version v2 = new Version("MLM_v1_07_00_2008_08_13");
        Version v3 = new Version("MLM_v1_07_00_2008_09_05");
        System.out.println(String.format("%d.%d.%d - %d/%d/%d", v1.getMajorVersion(), v1.getMinorVersion(), v1.getPatchVersion(), v1.getReleaseDay(), v1.getReleaseMonth(), v1.getReleaseYear()));
        System.out.println(v1.precedes(v2));
        System.out.println(v3.succeeds(v2));
        System.out.println(v2.compareTo(v2));
        System.out.println(v2.precedes(v2));
        System.out.println(v2.succeeds(v2));
    }
}

