/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmConfiguratorListener;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.CommandScript;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.remote.ClientRemoteLocator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AlgorithmConfigurator
implements Serializable {
    public static final String FILE_LIST_SEPARATOR = ",";
    private static final String UPDATE_ALGOVERSION_ERROR = "Erro ao atualizar vers\u00e3o do algoritmo";
    private static final String CPU_AMOUNT = "cpu";
    private static final float DEFAULT_CPU_AMOUNT = 0.0f;
    private static final String MEMORY_AMOUNT = "memory";
    private static final float DEFAULT_MEMORY_AMOUNT = 0.0f;
    private static final String REQUIREMENTS = "requirements";
    private static final String DEFAULT_REQUIREMENTS = "";
    private static final String REQUIREMENTS_SEPARATOR = "requirements_separator";
    private static final String DEFAULT_REQUIREMENTS_SEPARATOR = ",";
    private final ConfiguratorType configuratorType;
    private String abbreviation;
    private AlgorithmVersionInfo algorithmVersion;
    private String algorithmDescription;
    private String commandDescription;
    private ExecutionType executionType;
    private ExecutionLocation executionLocation;
    private String filePath;
    private FileParameterValue standardOutputFile;
    private FileParameterValue exitCodeLogFile;
    private boolean hasExitCode;
    private List<AlgorithmConfiguratorListener> listeners = new LinkedList<AlgorithmConfiguratorListener>();
    private boolean provideId;
    private final String commandLinePattern;

    protected AlgorithmConfigurator(ConfiguratorType type, AlgorithmVersionInfo algorithmVersion, String description, ExecutionType executionType, ExecutionLocation executionLocation, String abbreviation, boolean provideId, String commandLinePattern) {
        this(type, description, executionType, executionLocation, abbreviation, provideId, commandLinePattern);
        this.setAlgorithmVersion(algorithmVersion);
    }

    protected AlgorithmConfigurator(ConfiguratorType type, String description, ExecutionType executionType, ExecutionLocation executionLocation, String abbreviation, boolean provideId, String commandLinePattern) {
        this.configuratorType = type;
        this.algorithmDescription = description;
        this.abbreviation = abbreviation;
        this.provideId = provideId;
        this.hasExitCode = false;
        this.commandLinePattern = commandLinePattern;
        this.setExecutionType(executionType);
        this.setExecutionLocation(executionLocation);
    }

    public ConfiguratorType getConfiguratorType() {
        return this.configuratorType;
    }

    protected AlgorithmConfigurator(ConfiguratorType type, String filePath, String description, ExecutionType executionType, ExecutionLocation executionLocation, String abbreviation, boolean provideId, String commandLinePattern) {
        this(type, description, executionType, executionLocation, abbreviation, provideId, commandLinePattern);
        this.setFilePath(filePath);
    }

    public Set<FileParameterValue> getLogFiles() {
        HashSet<FileParameterValue> logFiles = new HashSet<FileParameterValue>();
        FileParameterValue theLogFile = this.getLogFile();
        if (null != theLogFile) {
            logFiles.add(theLogFile);
        }
        return Collections.unmodifiableSet(logFiles);
    }

    public final void addAlgorithmConfiguratorListener(AlgorithmConfiguratorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AlgorithmConfigurator configurator = (AlgorithmConfigurator)obj;
        if (this.getAlgorithmVersion() == null) {
            return this.getFilePath().equals(configurator.getFilePath());
        }
        return this.getAlgorithmVersion().equals(configurator.getAlgorithmVersion());
    }

    public abstract Map<Object, Object> exportValues();

    public final String getAbbreviation() {
        return this.abbreviation;
    }

    public final String getAlgorithmName() {
        if (this.algorithmVersion != null) {
            return this.algorithmVersion.getInfo().getName();
        }
        return null;
    }

    public final AlgorithmVersionInfo getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public final AlgorithmVersionId getAlgorithmVersionId() {
        if (this.algorithmVersion != null) {
            return this.algorithmVersion.getId();
        }
        return null;
    }

    public abstract Set<String> getBinaryDirectories(String var1, char var2);

    public abstract Set<String[]> getBinaryDirectoriesAsArray(String var1);

    public final float getCpuAmount() {
        return this.getFloatAlgorithmProperty(CPU_AMOUNT, 0.0f);
    }

    public final FileParameterValue getLogFile() {
        OutputFileParameter logFileParameter = this.getLogFileParameter();
        if (logFileParameter == null) {
            return null;
        }
        return (FileParameterValue)logFileParameter.getValue();
    }

    public final OutputFileParameter getLogFileParameter() {
        for (OutputFileParameter parameter : this.getOutputFileParameters()) {
            if (!parameter.isLogFile()) continue;
            return parameter;
        }
        return null;
    }

    public final float getMemoryAmount() {
        return this.getFloatAlgorithmProperty(MEMORY_AMOUNT, 0.0f);
    }

    public final String getCommandLinePattern() {
        return this.commandLinePattern;
    }

    public Set<String> getRequirements() {
        HashSet<String> requirementsSet = new HashSet<String>();
        String requirements = this.getStringAlgorithmProperty(REQUIREMENTS, DEFAULT_REQUIREMENTS);
        String sep = this.getStringAlgorithmProperty(REQUIREMENTS_SEPARATOR, ",");
        for (String requirement : requirements.split(sep)) {
            String req = requirement.trim();
            if (req.length() <= 0) continue;
            requirementsSet.add(req);
        }
        return requirementsSet;
    }

    public final String getDescription() {
        return this.algorithmDescription;
    }

    public abstract Set<FileParameterValue> getOutputDirectories();

    public abstract Set<FileParameterValue> getInputDirectories();

    public final ExecutionType getExecutionType() {
        return this.executionType;
    }

    public final ExecutionLocation getExecutionLocation() {
        return this.executionLocation;
    }

    public final SortedSet<FileParameter> getFileParameters() {
        TreeSet<FileParameter> fileParameters = new TreeSet<FileParameter>();
        List<InputFileParameter> inputFileParameters = this.getInputFileParameters();
        for (InputFileParameter inputFileParameter : inputFileParameters) {
            fileParameters.add(inputFileParameter);
        }
        List<OutputFileParameter> outputFileParameters = this.getOutputFileParameters();
        for (OutputFileParameter outputFileParameter : outputFileParameters) {
            fileParameters.add(outputFileParameter);
        }
        return Collections.unmodifiableSortedSet(fileParameters);
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public abstract List<InputFileParameter> getInputFileParameters();

    public abstract Set<FileParameterValue> getInputFiles();

    public abstract List<OutputFileParameter> getOutputFileParameters();

    public abstract Set<FileParameterValue> getOutputFiles();

    public abstract String getParameterLabel(String var1) throws ParameterNotFoundException;

    public abstract Set<String> getParameterNames();

    public abstract String getParameterType(String var1) throws ParameterNotFoundException;

    public abstract String getParameterValue(String var1) throws ParameterNotFoundException;

    public Map<String, String> getParameterValuesByName() {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (String parameterName : this.getParameterNames()) {
            try {
                parameterValues.put(parameterName, this.getParameterValue(parameterName));
            }
            catch (ParameterNotFoundException e) {
                throw new BugException(e);
            }
        }
        return parameterValues;
    }

    public abstract Set<String> getPlatforms();

    public final int hashCode() {
        if (this.getAlgorithmVersion() == null) {
            return this.getFilePath().hashCode();
        }
        return this.getAlgorithmVersion().hashCode();
    }

    public abstract void importValues(Map<Object, Object> var1) throws ParseException;

    public abstract boolean isEnabled();

    public final boolean isMultipleExecution() {
        return this.getExecutionType().equals((Object)ExecutionType.MULTIPLE);
    }

    public abstract boolean isSetDefaultValues();

    public final boolean isSimpleExecution() {
        return this.getExecutionType().equals((Object)ExecutionType.SIMPLE);
    }

    protected String getExitCodeCaptureCommand(CommandLineContext context) {
        FileParameterValue exitCodeLog;
        if (this.hasExitCode() && (exitCodeLog = this.getExitCodeLogFile()) != null) {
            String exitCodeFilePath = exitCodeLog.getPath();
            CommandLineBuilder builder = new CommandLineBuilder(context.isScript());
            CommandLineBuilder command = builder.appendExitCodeCaptureCommand(exitCodeFilePath, context);
            return command.toString();
        }
        return DEFAULT_REQUIREMENTS;
    }

    public abstract String makeCommandLine(CommandLineContext var1);

    public CommandScript[] makeCommandLineAsScript(CommandLineContext context) {
        String scriptContent = this.makeCommandLine(context);
        CommandScript commandScript = new CommandScript(context, scriptContent);
        return new CommandScript[]{commandScript};
    }

    public final boolean provideId() {
        return this.provideId;
    }

    public abstract void resetValues();

    public abstract boolean setDefaultInputFile(FileParameterValue var1);

    public abstract boolean setEnabled(boolean var1);

    public final boolean setLogFileParameterVisible(boolean isVisible) {
        OutputFileParameter logFileParameter = this.getLogFileParameter();
        if (logFileParameter == null) {
            return false;
        }
        if (logFileParameter.isVisible() == isVisible) {
            return false;
        }
        logFileParameter.setVisible(isVisible);
        return true;
    }

    public abstract void setParameterValue(String var1, String var2) throws ParseException, ParameterNotFoundException;

    public void setParameterValuesByName(Map<String, String> parameterValuesByName) throws ParseException, ParameterNotFoundException {
        ArrayList missingParameters = new ArrayList();
        for (String parameterName : parameterValuesByName.keySet()) {
            String parameterValue = parameterValuesByName.get(parameterName);
            try {
                this.setParameterValue(parameterName, parameterValue);
            }
            catch (ParameterNotFoundException e) {
                Collections.addAll(missingParameters, e.getParameterNames());
            }
        }
        if (!missingParameters.isEmpty()) {
            throw new ParameterNotFoundException(missingParameters.toArray(new String[missingParameters.size()]));
        }
    }

    public void updateAlgorithmVersion() throws Exception {
        if (this.getAlgorithmVersion() == null) {
            return;
        }
        AlgorithmVersionId versionId = this.getAlgorithmVersion().getId();
        if (versionId != null) {
            String algorithmName = this.getAlgorithmVersion().getInfo().getName();
            try {
                AlgorithmInfo algoInfo = ClientRemoteLocator.algorithmService.getInfo(algorithmName);
                AlgorithmVersionInfo versionInfo = algoInfo.getVersionInfo(versionId);
                this.setAlgorithmVersion(versionInfo);
            }
            catch (RemoteException re) {
                throw new Exception(UPDATE_ALGOVERSION_ERROR, re);
            }
        }
    }

    public String toString() {
        if (this.getAlgorithmVersion() == null) {
            return DEFAULT_REQUIREMENTS;
        }
        String algorithmName = this.getAlgorithmVersion().getInfo().getName();
        AlgorithmVersionId algorithmVersionId = this.getAlgorithmVersion().getId();
        return MessageFormat.format("{0} ({1})", algorithmName, algorithmVersionId);
    }

    public void setStandardOutputFile(FileParameterValue standardOutputFile) {
        this.standardOutputFile = standardOutputFile;
    }

    public FileParameterValue getStandardOutputFile() {
        return this.standardOutputFile;
    }

    public Set<FileParameterValue> getStandardOutputFiles() {
        if (null == this.standardOutputFile) {
            return Collections.emptySet();
        }
        HashSet<FileParameterValue> stdouts = new HashSet<FileParameterValue>();
        stdouts.add(this.standardOutputFile);
        return Collections.unmodifiableSet(stdouts);
    }

    protected abstract String getCurrentParameterFileVersion();

    protected final void fireParameterLabelWasChanged(String parameterName, String parameterLabel) {
        for (AlgorithmConfiguratorListener listener : this.listeners) {
            listener.parameterLabelWasChanged(this, parameterName, parameterLabel);
        }
    }

    protected final <V> void fireParameterValueWasChanged(String parameterName, V parameterValue) {
        for (AlgorithmConfiguratorListener listener : this.listeners) {
            listener.parameterValueWasChanged(this, parameterName, parameterValue);
        }
    }

    protected final void fireParameterWasSetEnabled(String parameterName, boolean parameterIsEnabled) {
        for (AlgorithmConfiguratorListener listener : this.listeners) {
            listener.parameterWasSetEnabled(this, parameterName, parameterIsEnabled);
        }
    }

    protected final void fireParameterWasSetVisible(String parameterName, boolean parameterIsVisible) {
        for (AlgorithmConfiguratorListener listener : this.listeners) {
            listener.parameterWasSetVisible(this, parameterName, parameterIsVisible);
        }
    }

    protected final void fireWasSetEnabled() {
        for (AlgorithmConfiguratorListener listener : this.listeners) {
            listener.wasSetEnabled(this);
        }
    }

    private String getStringAlgorithmProperty(String key, String defaultValue) {
        AlgorithmVersionInfo versionInfo = this.getAlgorithmVersion();
        if (versionInfo == null) {
            return defaultValue;
        }
        String stringValue = versionInfo.getInfo().getPropertyValue(key);
        if (stringValue == null) {
            return defaultValue;
        }
        return stringValue;
    }

    private float getFloatAlgorithmProperty(String key, float defaultValue) {
        AlgorithmVersionInfo versionInfo = this.getAlgorithmVersion();
        if (versionInfo == null) {
            return defaultValue;
        }
        String stringValue = versionInfo.getInfo().getPropertyValue(key);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(stringValue);
        }
        catch (NumberFormatException e) {
            String msg = MessageFormat.format("A chave {0} do algoritmo {1} cujo valor \u00e9 {2} n\u00e3o \u00e9 float. ", key, this, stringValue);
            throw new BugException(msg, e);
        }
    }

    private void setAlgorithmVersion(AlgorithmVersionInfo algorithmVersion) {
        if (algorithmVersion == null) {
            throw new IllegalArgumentException("O par\u00e2metro algorithmVersion est\u00e1 nulo.");
        }
        this.algorithmVersion = algorithmVersion;
    }

    public void setExecutionType(ExecutionType executionType) {
        if (executionType == null) {
            throw new IllegalArgumentException("O par\u00e2metro executionType est\u00e1 nulo.");
        }
        this.executionType = executionType;
    }

    public void setExecutionLocation(ExecutionLocation executionLocation) {
        if (executionLocation == null) {
            throw new IllegalArgumentException("O par\u00e2metro executionLocation est\u00e1 nulo.");
        }
        this.executionLocation = executionLocation;
    }

    private void setFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("O par\u00e2metro filePath est\u00e1 nulo.");
        }
        this.filePath = filePath;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public void setCommandDescription(String commandDescription) {
        this.commandDescription = commandDescription;
    }

    public boolean hasExitCode() {
        return this.hasExitCode;
    }

    public void setHasExitCode(boolean hasExitCode) {
        this.hasExitCode = hasExitCode;
    }

    public FileParameterValue getExitCodeLogFile() {
        return this.exitCodeLogFile;
    }

    public Set<FileParameterValue> getExitCodeLogFiles() {
        if (null == this.exitCodeLogFile) {
            return Collections.emptySet();
        }
        HashSet<FileParameterValue> exitCodeLogs = new HashSet<FileParameterValue>();
        exitCodeLogs.add(this.exitCodeLogFile);
        return Collections.unmodifiableSet(exitCodeLogs);
    }

    public void setExitCodeLogFile(FileParameterValue exitCodeLogFile) {
        this.exitCodeLogFile = exitCodeLogFile;
    }

    public boolean hasParameterThatRequiresPipe() {
        for (FileParameter param : this.getFileParameters()) {
            if (param.usesPipe() != FileParameterPipeAcceptance.ALWAYS) continue;
            return true;
        }
        return false;
    }

    public abstract Validation validate(ValidationContext var1) throws RemoteException;

    public static enum ConfiguratorType {
        SIMPLE,
        FLOW;

    }
}

