/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import java.util.Arrays;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;

public final class OutputFileParameter
extends FileParameter {
    public static final String TYPE = "OUTPUT_FILE";
    public static final String LOG_FILE_PARAMETER_NAME = "LOG_FILE";
    private boolean mustForceExtension;

    public OutputFileParameter(String name, String label, String description, FileParameterValue defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String fileType, FileParameterMode mode, FileParameterPipeAcceptance usesPipe, boolean mustForceExtension, boolean usesFilter) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, fileType, mode, usesPipe, usesFilter, false);
        if (!mode.equals((Object)FileParameterMode.DIRECTORY) && !mode.equals((Object)FileParameterMode.REGULAR_FILE)) {
            String errorMessage = String.format("Modo n\u00e3o suportado.\nModo fornecido: %s.\nModos suportados: %s.\n", new Object[]{mode, Arrays.asList(FileParameterMode.DIRECTORY, FileParameterMode.REGULAR_FILE)});
            throw new IllegalArgumentException(errorMessage);
        }
        this.mustForceExtension = mustForceExtension;
    }

    public static OutputFileParameter createLogFile(String commandLinePattern) {
        return new OutputFileParameter(LOG_FILE_PARAMETER_NAME, "Arquivo de Log", "Arquivo de Log", null, true, true, commandLinePattern, "LOG", FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.FALSE, false, false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean mustForceExtension() {
        return this.mustForceExtension;
    }

    public boolean isLogFile() {
        return this.getName().equals(LOG_FILE_PARAMETER_NAME);
    }

    @Override
    public boolean setValue(FileParameterValue file) {
        this.checkExtension(file);
        return super.setValue(file);
    }

    private void checkExtension(FileParameterValue file) {
        if (file != null && this.mustForceExtension()) {
            String filePath = file.getPath();
            String fileExtension = FileUtils.getFileExtension((String)filePath);
            String type = this.getFileType();
            ProjectFileType projectFileType = ProjectFileType.getFileType(type);
            if (projectFileType == null) {
                return;
            }
            List<String> extensions = projectFileType.getExtensions();
            if (extensions.isEmpty()) {
                return;
            }
            if (fileExtension == null || !extensions.contains(fileExtension)) {
                filePath = filePath + '.' + extensions.get(0);
                file.setPath(filePath);
            }
        }
    }
}

