/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLProtocolConverter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.StringToEnumConverter;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.EnumSet;

public abstract class AbstractURLParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    protected static final String MUST_SORT_ATTRIBUTE = "ordenar";
    protected static final boolean MUST_SORT_DEFAULT_VALUE = true;
    protected static final String CAN_USE_PIPE_ATTRIBUTE = "permitir_pipe";
    protected static final FileParameterPipeAcceptance CAN_USE_PIPE_DEFAULT_VALUE = FileParameterPipeAcceptance.TRUE;
    protected static final String CATEGORY_ATTRIBUTE = "categoria";
    protected static final String CATEGORY_VALUE_DIRECTORY = "diretorio";
    protected static final String CATEGORY_VALUE_REGULAR_FILE = "arquivo";
    protected static final String PROTOCOLS_ATTRIBUTE = "protocolos";
    protected static final String DEFAULT_DIRECTORY_ATTRIBUTE = "usar_diretorio_raiz_como_padrao";
    protected static final boolean DEFAULT_DIRECTORY_DEFAULT_VALUE = false;
    protected static final String TYPE_ATTRIBUTE = "tipo";
    protected static final String LOCALIZATION_ATTRIBUTE = "localizacao";

    @Override
    public final T createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        EnumSet<URLProtocol> allowedProtocols;
        String protocols;
        FileParameterMode mode;
        ProjectFileType projectFileType;
        String localization = parser.extractAttributeValue(LOCALIZATION_ATTRIBUTE);
        String type = parser.extractAttributeValue(TYPE_ATTRIBUTE, null);
        String modeName = parser.extractAttributeValue(CATEGORY_ATTRIBUTE, null);
        if (modeName == null) {
            mode = type != null ? ((projectFileType = ProjectFileType.getFileType(type)).isDirectory() ? FileParameterMode.DIRECTORY : FileParameterMode.REGULAR_FILE) : FileParameterMode.REGULAR_FILE;
        } else if (modeName.equals(CATEGORY_VALUE_DIRECTORY)) {
            mode = FileParameterMode.DIRECTORY;
        } else if (modeName.equals(CATEGORY_VALUE_REGULAR_FILE)) {
            mode = FileParameterMode.REGULAR_FILE;
        } else {
            throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 v\u00e1lida.\nCategorias v\u00e1lidas:\n{1};\n{2}.", modeName, CATEGORY_VALUE_REGULAR_FILE, CATEGORY_VALUE_DIRECTORY);
        }
        if (type != null) {
            projectFileType = ProjectFileType.getFileType(type);
            if (!projectFileType.isDirectory() && mode == FileParameterMode.DIRECTORY) {
                throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 compat\u00edvel com o tipo informado {1}, pois o tipo \u00e9 aplicavel somente a arquivos.", modeName, type);
            }
            if (projectFileType.isDirectory() && mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 compat\u00edvel com o tipo informado {1}, pois o tipo \u00e9 aplicavel somente a diret\u00f3rios.", modeName, type);
            }
        } else {
            switch (mode) {
                case DIRECTORY: {
                    type = "DIRECTORY_TYPE";
                    break;
                }
                case REGULAR_FILE: 
                case DIRECTORY_AND_REGULAR_FILE: {
                    type = "UNKNOWN";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Modo n\u00e3o tratado %s.", new Object[]{mode}));
                }
            }
        }
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean(DEFAULT_DIRECTORY_ATTRIBUTE, false);
        FileURLValue defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException("O atributo {0} \u00e9 inv\u00e1lido quando o par\u00e2metro de sa\u00edda \u00e9 um arquivo.", DEFAULT_DIRECTORY_ATTRIBUTE);
            }
            defaultValue = new FileURLValue(".", "DIRECTORY_TYPE");
        }
        if ((protocols = parser.extractAttributeValue(PROTOCOLS_ATTRIBUTE, null)) != null) {
            allowedProtocols = EnumSet.noneOf(URLProtocol.class);
            String[] protocolsAsArray = protocols.split(",");
            URLProtocolConverter converter = new URLProtocolConverter();
            for (String protocolString : protocolsAsArray) {
                URLProtocol protocol = converter.valueOf(protocolString);
                allowedProtocols.add(protocol);
            }
        } else {
            allowedProtocols = EnumSet.allOf(URLProtocol.class);
        }
        FileParameterPipeAcceptance usesPipe = parser.extractAttributeValueAsEnumeration(CAN_USE_PIPE_ATTRIBUTE, CAN_USE_PIPE_DEFAULT_VALUE, new URLParameterPipeAcceptanceConverter());
        return this.createURLParameter(parser, name, label, description, isOptional, isVisible, commandLinePattern, type, localization, mode, defaultValue, usesPipe, allowedProtocols);
    }

    protected abstract T createURLParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, String var8, String var9, FileParameterMode var10, FileURLValue var11, FileParameterPipeAcceptance var12, EnumSet<URLProtocol> var13) throws ParseException;

    protected class URLParameterPipeAcceptanceConverter
    implements StringToEnumConverter<FileParameterPipeAcceptance> {
        protected URLParameterPipeAcceptanceConverter() {
        }

        public String[] getPossibleMatches(FileParameterPipeAcceptance value) {
            switch (value) {
                case TRUE: {
                    return XmlParser.TRUE_VALUES;
                }
                case FALSE: {
                    return XmlParser.FALSE_VALUES;
                }
                case ALWAYS: {
                    return new String[]{"sempre", "always"};
                }
            }
            throw new BugException();
        }

        @Override
        public FileParameterPipeAcceptance valueOf(String string) throws ParseException {
            if (string != null) {
                String upperCaseString = string.toUpperCase();
                for (FileParameterPipeAcceptance mode : FileParameterPipeAcceptance.values()) {
                    String[] possibleMatches;
                    for (String possibleMatch : possibleMatches = this.getPossibleMatches(mode)) {
                        if (!possibleMatch.toUpperCase().equals(upperCaseString)) continue;
                        return mode;
                    }
                }
            }
            throw new ParseException("A string " + string + " n\u00e3o p\u00f4de ser mapeada para um item de enumera\u00e7\u00e3o do tipo " + FileParameterPipeAcceptance.class.getName());
        }
    }
}

