/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.RowValue;
import csbase.logic.algorithms.parameters.RowValueListener;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameterListener;
import csbase.logic.algorithms.parameters.TableParameterParser;
import csbase.logic.algorithms.parameters.validators.TableParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.parsers.exception.AutomatonException;

public final class TableParameter
extends SimpleParameter<List<RowValue>>
implements RowValueListener {
    public static final String TYPE = "TABLE";
    private List<TableColumn<?>> columns;
    private boolean delimitRows;
    private boolean delimitTable;
    private Integer fixedRowCount;
    private transient List<TableParameterListener> listeners;
    private List<RowValue> rowValues;
    private Integer visibleRowCount;
    private Integer maxRowCount;
    private Integer minRowCount;

    public TableParameter(String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, List<? extends TableColumn<?>> columns, boolean delimitTable, boolean delimitRows, Integer fixedRowCount, Integer visibleRowCount, Integer minRowCount, Integer maxRowCount) {
        super(name, label, description, null, isOptional, isVisible, commandLinePattern);
        this.setColumns(columns);
        this.testIfPositive(visibleRowCount, LNG.get((String)"csbase.logic.algorithms.parameters.visibleRowCount"));
        this.testIfPositive(fixedRowCount, LNG.get((String)"csbase.logic.algorithms.parameters.fixedRowCount"));
        this.testIfPositive(maxRowCount, LNG.get((String)"csbase.logic.algorithms.parameters.maxRowCount"));
        this.testIfPositive(minRowCount, LNG.get((String)"csbase.logic.algorithms.parameters.minRowCount"));
        if (maxRowCount != null && minRowCount != null && maxRowCount < minRowCount) {
            String fmt = LNG.get((String)"csbase.logic.algorithms.parameters.InconsistentValues");
            String err = String.format(fmt, minRowCount, maxRowCount);
            throw new IllegalArgumentException(err);
        }
        this.visibleRowCount = visibleRowCount;
        this.fixedRowCount = fixedRowCount;
        this.maxRowCount = maxRowCount;
        this.minRowCount = minRowCount;
        this.delimitTable = delimitTable;
        this.delimitRows = delimitRows;
        this.listeners = new LinkedList<TableParameterListener>();
        this.rowValues = new ArrayList<RowValue>();
        this.setValue(this.rowValues);
        this.createDefaultRows();
    }

    private void testIfPositive(Integer value, String name) {
        if (value != null && value <= 0) {
            String fmt = "%s n\u00e3o positivo. Valor = %d";
            String err = String.format("%s n\u00e3o positivo. Valor = %d", name, value);
            throw new IllegalArgumentException(err);
        }
    }

    public final void addTableParameterListener(TableParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    public final void addRow(RowValue rowValue) {
        if (rowValue == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "rowValue"));
        }
        rowValue.addRowValueListener(this);
        int rowIndex = this.rowValues.size();
        this.rowValues.add(rowValue);
        this.fireRowWasCreated(rowValue, rowIndex);
        this.fireValueWasChangedEvent();
    }

    public final void createRow() {
        int rowIndex = this.rowValues.size();
        Object[] row = new Object[this.getColumnCount()];
        for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
            TableColumn<?> column = this.columns.get(columnIndex);
            row[columnIndex] = column.getDefaultValue(rowIndex);
        }
        RowValue rowValue = new RowValue(row);
        this.addRow(rowValue);
    }

    public final boolean hasFixedRowCount() {
        return this.fixedRowCount != null;
    }

    public final void removeRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            String message = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.RowIndexOutOfBounds"), new Integer(rowIndex), new Integer(this.getRowCount()));
            throw new IllegalArgumentException(message);
        }
        RowValue rowValue = this.rowValues.get(rowIndex);
        rowValue.removeRowValueListener(this);
        this.rowValues.remove(rowIndex);
        this.fireRowWasRemoved(rowValue, rowIndex);
        this.fireValueWasChangedEvent();
    }

    public final boolean delimitRows() {
        return this.delimitRows;
    }

    public final boolean delimitTable() {
        return this.delimitTable;
    }

    public final int getColumnCount() {
        return this.columns.size();
    }

    public final Integer getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public final Integer getMaxRowCount() {
        return this.maxRowCount;
    }

    public final Integer getMinRowCount() {
        return this.minRowCount;
    }

    public final List<TableColumn<?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public final TableColumn<?> getColumnById(String columnId) {
        for (TableColumn<?> column : this.columns) {
            if (!column.getId().equals(columnId)) continue;
            return column;
        }
        return null;
    }

    @Override
    public final String getCommandValue(CommandLineContext context) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.getColumnCount() == 0) {
            return null;
        }
        String commandValue = "";
        if (this.delimitTable()) {
            commandValue = commandValue + "{";
        }
        String rowSeparator = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            commandValue = commandValue + rowSeparator;
            if (this.delimitRows()) {
                commandValue = commandValue + "{";
            }
            String cellSeparator = "";
            for (int j = 0; j < this.columns.size(); ++j) {
                commandValue = commandValue + cellSeparator;
                Object itemValue = this.getItemValue(i, j);
                TableColumn<?> column = this.columns.get(j);
                String itemCommandValue = column.getCommandValue(itemValue, context);
                commandValue = commandValue + itemCommandValue;
                cellSeparator = ",";
            }
            if (this.delimitRows()) {
                commandValue = commandValue + "}";
            }
            rowSeparator = ",";
        }
        if (this.delimitTable()) {
            commandValue = commandValue + "}";
        }
        return commandValue;
    }

    @Override
    public final Object getExpressionValue() {
        return this.getName();
    }

    public final Object getItemValue(int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            String message = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.NoLinesGet"), new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (this.getColumnCount() == 0) {
            String message = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.NoColumnsGet"), new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.ParamRowIndexOutOfBounds"), new Integer(this.getRowCount()), new Integer(rowIndex)));
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.ParamColumnIndexOutOfBounds"), new Integer(this.getColumnCount()), new Integer(columnIndex)));
        }
        RowValue rowValue = this.rowValues.get(rowIndex);
        return rowValue.getCellValue(columnIndex);
    }

    public final int getRowCount() {
        return this.rowValues.size();
    }

    public final List<RowValue> getRowValues() {
        return Collections.unmodifiableList(this.rowValues);
    }

    public final List<TableParameterListener> getTableParameterListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public final String getType() {
        return TYPE;
    }

    @Override
    public final String getValueAsText() {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.getColumnCount() == 0) {
            return null;
        }
        String text = "";
        text = text + '{';
        String rowSeparator = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            text = text + rowSeparator;
            text = text + '{';
            String cellSeparator = "";
            for (int j = 0; j < this.columns.size(); ++j) {
                Object itemValue = this.getItemValue(i, j);
                TableColumn<?> column = this.columns.get(j);
                String itemText = column.getItemValueAsText(itemValue);
                if (itemText == null) {
                    itemText = "";
                }
                text = text + cellSeparator;
                text = text + itemText;
                cellSeparator = Character.toString(',');
            }
            text = text + '}';
            rowSeparator = Character.toString(',');
        }
        text = text + '}';
        return text;
    }

    @Override
    public final Map<String, Object> exportValue() {
        ArrayList<Object[]> newRowValues = new ArrayList<Object[]>(this.getRowCount());
        for (int i = 0; i < this.rowValues.size(); ++i) {
            RowValue rowValue = this.rowValues.get(i);
            List<Object> cellValueList = rowValue.getCellValues();
            Object[] cellValues = new Object[cellValueList.size()];
            for (int j = 0; j < cellValues.length; ++j) {
                TableColumn<?> column = this.columns.get(j);
                Object cellValue = cellValueList.get(j);
                cellValues[j] = column.getValueToExport(cellValue);
            }
            newRowValues.add(cellValues);
        }
        HashMap<String, ArrayList<Object[]>> parameterValue = new HashMap<String, ArrayList<Object[]>>();
        parameterValue.put(this.getName(), newRowValues);
        return Collections.unmodifiableMap(parameterValue);
    }

    @Override
    public final void importValue(Map<String, Object> parameterValues) {
        if (parameterValues == null) {
            String err = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterValues");
            throw new IllegalArgumentException(err);
        }
        this.clearRows();
        List values = (List)parameterValues.get(this.getName());
        if (values != null) {
            int i;
            for (i = 0; i < values.size(); ++i) {
                this.createRow();
            }
            for (i = 0; i < values.size(); ++i) {
                Object[] cellValues = (Object[])values.get(i);
                for (int j = 0; j < cellValues.length; ++j) {
                    TableColumn<?> column = this.columns.get(j);
                    this.setItemValue(column.getValueToImport(cellValues[j]), i, j);
                }
            }
        }
    }

    @Override
    public final void resetValue() {
        this.clearRows();
        this.createDefaultRows();
    }

    public final boolean setItemValue(Object value, int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            String message = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.NoLinesSet"), value, new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (this.getColumnCount() == 0) {
            String message = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.NoColumnsSet"), value, new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.ParamRowIndexOutOfBounds"), new Integer(this.getRowCount()), new Integer(rowIndex)));
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.ParamColumnIndexOutOfBounds"), new Integer(this.getColumnCount()), new Integer(columnIndex)));
        }
        RowValue rowValue = this.rowValues.get(rowIndex);
        Object oldValue = rowValue.getCellValue(columnIndex);
        if (oldValue == null && value == null) {
            return false;
        }
        if (oldValue != null && oldValue.equals(value)) {
            return false;
        }
        rowValue.setCellValue(value, columnIndex);
        return true;
    }

    @Override
    public final void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue != null) {
            int i;
            List<List<String>> table;
            TableParameterParser parser = new TableParameterParser();
            try {
                table = parser.parseText(parameterValue);
            }
            catch (AutomatonException e) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidTextToTable"), parameterValue, this);
            }
            for (int i2 = 0; i2 < table.size(); ++i2) {
                List<String> row = table.get(i2);
                if (row.size() == this.getColumnCount()) continue;
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.TableSizeNotMatch"), parameterValue, this, new Integer(row.size()), new Integer(this.getColumnCount()));
            }
            Object[][] newValues = new Object[table.size()][this.getColumnCount()];
            for (i = 0; i < table.size(); ++i) {
                List<String> row = table.get(i);
                for (int j = 0; j < row.size(); ++j) {
                    TableColumn<?> column = this.getColumns().get(j);
                    String itemValueAsText = row.get(j);
                    Object itemValue = column.getItemValueFromText(itemValueAsText);
                    newValues[i][j] = itemValue;
                }
            }
            this.clearRows();
            for (i = 0; i < newValues.length; ++i) {
                this.createRow();
            }
            for (i = 0; i < newValues.length; ++i) {
                for (int j = 0; j < newValues[i].length; ++j) {
                    Object itemValue = newValues[i][j];
                    this.setItemValue(itemValue, i, j);
                }
            }
        } else {
            this.clearRows();
        }
    }

    @Override
    public final void valueWasChanged(Object newValue, int columnIndex) {
        this.fireValueWasChangedEvent();
    }

    private void createDefaultRows() {
        if (this.fixedRowCount != null) {
            for (int rowIndex = 0; rowIndex < this.fixedRowCount; ++rowIndex) {
                this.createRow();
            }
        }
    }

    private void clearRows() {
        if (this.getRowCount() != 0) {
            do {
                this.removeRow(this.getRowCount() - 1);
            } while (this.getRowCount() != 0);
            this.fireValueWasChangedEvent();
        }
    }

    private void setColumns(List<? extends TableColumn<?>> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "columns"));
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.EmptyParameter"), "columns"));
        }
        this.columns = new ArrayList(columns);
    }

    private void fireRowWasCreated(RowValue rowValue, int rowIndex) {
        for (TableParameterListener listener : this.listeners) {
            listener.rowWasCreated(this, rowValue, rowIndex);
        }
    }

    private void fireRowWasRemoved(RowValue rowValue, int rowIndex) {
        for (TableParameterListener listener : this.listeners) {
            listener.rowWasRemoved(this, rowValue, rowIndex);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<TableParameterListener>();
    }

    public final TableParameterValidator createParameterValidator() {
        return new TableParameterValidator(this.isOptional(), this.getColumns());
    }
}

