/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import tecgraf.javautils.core.lng.LNG;

public final class TextParameterValidator
extends SimpleParameterValidator<String> {
    private Integer maxCharacters;

    public TextParameterValidator(boolean isOptional, Integer maxCharacters) {
        super(isOptional);
        this.setMaxCharacters(maxCharacters);
    }

    public Integer getMaxCharacters() {
        return this.maxCharacters;
    }

    @Override
    public Validation validateValue(SimpleParameter<?> parameter, String value, ValidationContext context) throws RemoteException {
        Validation validationResult = super.validateValue(parameter, value, context);
        if (!validationResult.isWellSucceded()) {
            return validationResult;
        }
        if (parameter.isEnabled() && parameter.isVisible() && value != null) {
            if (this.getMaxCharacters() != null && value.length() > this.getMaxCharacters()) {
                LocalizedMessage message = new LocalizedMessage(TextParameterValidator.class, "above_max_characteres", new Object[]{parameter.getLabel(), value, value.length(), this.getMaxCharacters()});
                return new ValidationError(message);
            }
            if (!value.matches("[:/#\\w\\.-]+")) {
                LocalizedMessage message = new LocalizedMessage(TextParameterValidator.class, "illegal_characteres", new Object[]{parameter.getLabel(), value});
                return new ValidationError(message);
            }
        }
        return new ValidationSuccess();
    }

    private void setMaxCharacters(Integer maxCharacters) {
        if (maxCharacters != null && maxCharacters <= 0) {
            throw new IllegalArgumentException(String.format(LNG.get((String)"csbase.logic.algorithms.positiveParameter"), "maxCharacters", maxCharacters.toString()));
        }
        this.maxCharacters = maxCharacters;
    }
}

