/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class InputFileParameterParser
extends AbstractFileParameterParser<InputFileParameter> {
    public static final String INPUT_FILE_PARAMETER_ELEMENT = "arquivo_de_entrada";

    @Override
    public InputFileParameter createFileParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String[] types, FileParameterMode mode) throws ParseException {
        boolean mustSort;
        boolean sortDefined = parser.hasAttributeValue("ordenar");
        if (sortDefined && (mustSort = parser.extractAttributeValueAsBoolean("ordenar", true))) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.InputSingleFileNoAttribute") + "ordenar");
        }
        FileParameterPipeAcceptance usesPipe = parser.extractAttributeValueAsEnumeration("permitir_pipe", FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE, new AbstractFileParameterParser.FileParameterPipeAcceptanceConverter(this));
        if (usesPipe != FileParameterPipeAcceptance.FALSE && types.length > 1) {
            throw new ParseException("O valor {0} do atributo {1} \u00e9 inv\u00e1lido quando se tem mais de um tipo de arquivo definido no par\u00e2metro.", new Object[]{usesPipe, "permitir_pipe"});
        }
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean("usar_diretorio_raiz_como_padrao", false);
        FileURLValue defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.InputFileInvalidAttribute"), "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new FileURLValue(".", "DIRECTORY_TYPE");
        }
        boolean useFilter = parser.extractAttributeValueAsBoolean("usar_filtro", false);
        InputFileParameter parameter = new InputFileParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, types, mode, usesPipe, useFilter);
        return parameter;
    }

    @Override
    public List<Class<? extends Parameter>> getParameterTypes() {
        return Collections.singletonList(InputFileParameter.class);
    }

    @Override
    protected boolean acceptBothCategory() {
        return true;
    }
}

