package csbase.console;

import java.util.regex.Pattern;

import org.kohsuke.args4j.Option;

/**
 * Parmetros da linha de comando a serem tratados via args4j.
 * 
 * @author Tecgraf
 */
class AdminParams extends BasicParams {
  /**
   * Verso do servidor.
   */
  @Option(name = "--version", aliases = "-v", usage = "verso do sistema")
  boolean version;

  /**
   * Login do usurio (opcional, default = admin).
   */
  @Option(name = "--user", aliases = "-u", usage = "login do usurio (opcional)", metaVar = "usr")
  String userLogin = null;

  /**
   * Lista usurios logados.
   */
  @Option(name = "--logged", usage = "lista usurios logados")
  boolean listLoggedUsers = false;

  /**
   * Encerra execuo do servidor.
   */
  @Option(name = "--shutdown", usage = "encerra execuo do servidor")
  boolean shutdown;

  /**
   * No exige confirmao para algumas operaes (p.ex. shutdown).
   */
  @Option(name = "--force", usage = "no exige confirmao para operaes")
  boolean force;

  /**
   * Lista SGAs cadastrados no servidor.
   */
  @Option(name = "--sgas", usage = "lista SGAs cadastrados no servidor")
  boolean listSGAs;

  /**
   * Encerra execuo de todos os SGAs.
   */
  @Option(name = "--sgas-stop", usage = "encerra a execuo de todos os SGAs")
  boolean stopAllSGAs;

  /**
   * Reinicia execuo de todos os SGAs.
   */
  @Option(name = "--sgas-restart", usage = "reinicia a execuo de todos os SGAs")
  boolean restartAllSGAs;

  /**
   * Encerra a execuo de um SGA especfico.
   */
  @Option(name = "--sga-stop", usage = "encerra a execuo de um SGA", metaVar = "sga")
  String sgaToStop;

  /**
   * Reinicia a execuo de um SGA especfico.
   */
  @Option(name = "--sga-restart", usage = "reinicia a execuo de um SGA", metaVar = "sga")
  String sgaToRestart;

  /**
   * Obtm informaes de um SGA.
   */
  @Option(name = "--sga-info", usage = "obtm informaes de um SGA", metaVar = "sga")
  String sgaToGetInfo;

  /**
   * Interrompe a execuo de um comando.
   */
  @Option(name = "--cmd-kill", usage = "interrompe execuo de um comando", metaVar = "cmdId")
  String cmdIdToKill;

  /**
   * Bloqueia/desbloqueia a fila de comandos.
   */
  @Option(name = "--cmds-block", usage = "bloqueia/desbloqueia a fila de comandos", metaVar = "true/false")
  String blockCmdQueue;

  /**
   * Lista propriedades carregadas pelo servidor.
   */
  @Option(name = "--props", usage = "lista propriedades carregadas pelo servidor")
  boolean listProps;

  /**
   * Padro usado na filtragem das propriedades.
   */
  Pattern propsPattern;

  /**
   * Filtro para a exibio das propriedades. Por enquanto, permitimos apenas
   * strings "simples" (!regex). Seria trivial usar regexes, mas neste caso
   * talvez uma nova opo especfica para isto deva ser criada.
   * 
   * @param string
   */
  @SuppressWarnings("unused")
  @Option(name = "--props-filter", usage = "lista apenas as propriedades que contm uma string\n(usar com --props)", metaVar = "string")
  private void propsRegex(String string) {
    propsPattern =
      Pattern.compile(".*" + Pattern.quote(string) + ".*", Pattern.MULTILINE);
  }

  /**
   * Envia uma mensagem para todos os usurios. A mensagem aparecer como popup
   * e ser voltil.
   */
  @Option(name = "--msg-all", usage = "envia mensagem para todos os usurios", metaVar = "msg")
  String msgToAll;

  /**
   * Envia uma mensagem apenas para os usurios conectados. A mensagem aparecer
   * como popup e ser voltil.
   */
  @Option(name = "--msg-logged", usage = "envia mensagem para usurios conectados", metaVar = "msg")
  String msgToLogged;

  /**
   * Envia uma mensagem para um usurio especfico. A mensagem aparecer como
   * popup e ser voltil.
   * 
   * @see #msgRecipient
   */
  @Option(name = "--msg", usage = "envia mensagem para um usurio\n(usar com --msg-user)", metaVar = "msg")
  String msgToUser;

  /**
   * Destinatrio da mensagem definida via <code>--msg</code>. A mensagem
   * aparecer como popup e ser voltil.
   */
  @Option(name = "--msg-user", usage = "destinatrio da mensagem enviada por --msg", metaVar = "user")
  String msgRecipient;

  /**
   * Arquivo remoto a ser copiado para o disco local.
   * 
   * @see #localDestDir
   */
  @Option(name = "--copy-remote", usage = "copia arquivo remoto para o disco local\n(usar com --to-local)", metaVar = "[usr:]prj/path")
  String remoteSrcPath;

  /**
   * Diretrio remoto para onde ser copiado um arquivo local.
   * 
   * @see #localSrcPath
   */
  @Option(name = "--to-remote", usage = "diretrio remoto para cpia\n(usar com --copy-local)", metaVar = "[usr:]prj/path")
  String remoteDestDir;

  /**
   * Arquivo local que ser copiado para um diretrio remoto.
   * 
   * @see #remoteDestDir
   */
  @Option(name = "--copy-local", usage = "copia arquivo local para um projeto\n(usar com --to-remote)", metaVar = "path")
  String localSrcPath;

  /**
   * Diretrio local para onde ser copiado um arquivo remoto.
   * 
   * @see #remoteSrcPath
   */
  @Option(name = "--to-local", usage = "diretrio local para cpia (default = dir corrente)\n(usar com --copy-remote)", metaVar = "dir")
  String localDestDir;

  /**
   * Diretrio remoto a ser criado.
   */
  @Option(name = "--create-dir", usage = "criar diretrio remoto", metaVar = "[usr:]prj/path")
  String dirToCreate;

  /**
   * Projeto a ser criado.
   */
  @Option(name = "--create-prj", usage = "criar projeto", metaVar = "[usr:]prj")
  String prjToCreate;

  /**
   * Arquivo/diretrio remoto a ser removido.
   */
  @Option(name = "--remove", usage = "remover arquivo/diretrio remoto", metaVar = "[usr:]prj/path")
  String fileToremove;

  // FIXME desabilitado temporariamente
  //  /**
  //   * Projeto a ser removido.
  //   */
  //  @Option(name = "--remove-prj", usage = "remover projeto", metaVar = "[usr:]prj")
  //  String prjToRemove;
}