package csbase.console;

import org.kohsuke.args4j.Option;

/**
 * Parmetros especficos do cliente console para importao de um Pacote de
 * Algoritmos (PA).
 * 
 */
public class AlgorithmsPackParams extends BasicParams {
  /**
   * Login do usurio (opcional, default = admin).
   */
  @Option(name = "--user", aliases = "-u", usage = "login do usurio (opcional)", metaVar = "<login do usurio>")
  String userLogin = null;

  /**
   * Comando para iniciar o processo de manipulao do PA para importao. Esse
   * comando realiza a transferncia do PA para o servidor (no diretrio
   * especificad no arquivo de propriedades do sistema) e retorna um token para
   * o dado do PA que requisitou essa iniciao. Esse token dever ser passado
   * para todas as demais operaes sobre esse PA.
   * 
   */
  @Option(name = "--start", usage = "inicia a manipulao do PA especificado para importao. \nEssa operao retona um token no console, que dever ser passado nos outros comandos sobre um Pacote de Algoritmos. ", metaVar = "<path do arquivo local do PA>")
  String startPA;

  /**
   * Token que corresponde ao dado do PA a ser manipulado. \nEsse parmetro 
   * obrigatrio em todas as operaes sobre o PA, exceto na de inicializao
   * (startPA).
   * 
   */
  @Option(name = "--token", usage = "informa o identificador nico (token) que corresponde ao dado do PA a ser manipulado. \nEsse parmetro  obrigatrio em todas as operaes sobre o PA, exceto na de inicializao (startPA).", metaVar = "<token do dado(PA)>")
  String token;

  /**
   * Comando para validar o PA antes da importao de fato.
   * 
   */
  @Option(name = "--validate", usage = "valida o PA especificado pelo token antes da importao de fato.")
  boolean validatePA;

  /**
   * Comando para finalizar o processo de manipulao do PA para importao.
   * 
   */
  @Option(name = "--finish", usage = "termina a manipulao do PA especificado pelo token, para o processo de importao.")
  boolean finishPA;

  /**
   * Lista as informaes principais dos algoritmos do pacote de algoritmos.
   */
  @Option(name = "--algorithms", usage = "lista algoritmos do Pacote de Algoritmos")
  boolean listAlgorithms;

  /**
   * Detalha as informaes de um algoritmo do PA.
   */
  @Option(name = "--algorithm-info", aliases = "-algo-info", usage = "lista as informaes de um algoritmo do PA", metaVar = "<nome do algoritmo>")
  String algoToList;

  /**
   * Substitui todo o contudo de um algoritmo no repositrio.
   */
  @Option(name = "--replace", usage = "substitui todo o contedo do algoritmo no repositrio")
  boolean replaceAlgorithms;

  /**
   * Realiza a juno de verses e/ou categorias do algoritmo no repositrio.
   */
  @Option(name = "--merge", usage = "realiza a juno de verses e/ou categorias do algoritmo no repositrio")
  boolean mergeAlgorithms;

  /**
   * Conserva o algoritmo que j faz parte do repositrio.
   */
  @Option(name = "--keep", usage = "conserva o algoritmo que j faz parte do repositrio")
  boolean keepAlgorithms;

  //**********************************************************
  // Opes para se usar com o parmetro de algoritmos --merge 
  //**********************************************************

  /**
   * Substitui todo o contudo da verso do algoritmo no repositrio.
   */
  @Option(name = "--replace-versions", usage = "substitui todo o contedo da verso do algoritmo no repositrio\n(usar com --merge)")
  boolean replaceVersions;

  /**
   * Conserva a verso do algoritmo que j faz parte do repositrio.
   */
  @Option(name = "--keep-versions", usage = "conserva a verso do algoritmo que j faz parte do repositrio\n(usar com --merge)")
  boolean keepVersions;

  /**
   * Substitui a hierarquia da categoria de um algoritmo no repositrio.
   */
  @Option(name = "--replace-categories", usage = "substitui toda a hierarquia da categoria do algoritmo no repositrio\n(usar com --merge)")
  boolean replaceCategories;

  /**
   * Realiza a juno de categorias do algoritmo no repositrio.
   */
  @Option(name = "--merge-categories", usage = "realiza a juno da categoria do algoritmo no repositrio\n(usar com --merge)")
  boolean mergeCategories;

  /**
   * Conserva o algoritmo que j faz parte do repositrio.
   */
  @Option(name = "--keep-categories", usage = "conserva o algoritmo que j faz parte do repositrio\n(usar com --merge)")
  boolean keepCategories;

  //********** Fim das opes com --merge ********************

}
