package csbase.console;

import org.kohsuke.args4j.Option;

/**
 * Parmetros especficos do cliente console para importao de uma verso de
 * algoritmo.
 *
 * @author Tecgraf
 */
public class AlgorithmsVersionParams extends BasicParams {

  /**
   * Login do usurio (opcional, default = admin).
   */
  @Option(name = "--user", aliases = "-u", usage = "login do usurio (opcional)", metaVar = "<login do usurio>")
  String userLogin = null;

  /**
   * Id do algoritmo.
   */
  @Option(name = "--algorithm-id", required = true, aliases = "-i", usage = "id do algoritmo", metaVar = "<id do algoritmo>")
  String algorithmId = null;

  /**
   * Caminho para o arquivo zip que contm a verso do algoritmo.
   */
  @Option(name = "--zip-path", aliases = "-z", required = true, usage = "caminho para o zip de verso", metaVar = "<zip de verso>")
  String versionZipPath = null;

}
