/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.Admin;
import csbase.console.CheckBundlesApp;
import csbase.console.ConsoleOperation;
import csbase.console.CreateAlgorithm;
import csbase.console.Diagnostics;
import csbase.console.ExitCode;
import csbase.console.ImportAlgoVersion;
import csbase.console.ListAlgoCategories;
import csbase.console.ListAlgoVersions;
import csbase.console.RemoveAlgoVersion;
import csbase.console.RemoveAlgorithm;
import csbase.console.Statistics;
import java.util.Arrays;
import tecgraf.javautils.configurationmanager.ConfigurationManager;

public class CSBaseConsole {
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].trim().equalsIgnoreCase("-h")) {
            CSBaseConsole.printHelp();
            System.exit(ExitCode.FAILURE.getCode());
            return;
        }
        String command = args[0];
        ConsoleOperation operation = ConsoleOperation.getOperationFromName(command);
        if (operation == null) {
            System.out.println("Comando " + command + " n\u00e3o identificado.");
            CSBaseConsole.printHelp();
            System.exit(ExitCode.FAILURE.getCode());
            return;
        }
        ConfigurationManager.createInstance();
        String[] opArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        AbstractConsoleApp console = null;
        switch (operation) {
            case ADMIN: {
                console = new Admin(opArgs);
                break;
            }
            case DIAGNOSTICS: {
                console = new Diagnostics(opArgs);
                break;
            }
            case CHECK_BUNDLES: {
                console = new CheckBundlesApp(opArgs);
                break;
            }
            case STATISTICS: {
                console = new Statistics(opArgs);
                break;
            }
            case ADD_VERSION: {
                console = new ImportAlgoVersion(opArgs);
                break;
            }
            case CREATE_ALGORITHM: {
                console = new CreateAlgorithm(opArgs);
                break;
            }
            case LIST_VERSIONS: {
                console = new ListAlgoVersions(opArgs);
                break;
            }
            case REMOVE_ALGORITHM: {
                console = new RemoveAlgorithm(opArgs);
                break;
            }
            case REMOVE_VERSION: {
                console = new RemoveAlgoVersion(opArgs);
                break;
            }
            case LIST_CATEGORIES: {
                console = new ListAlgoCategories(opArgs);
                break;
            }
            default: {
                System.out.println("Tratamento de comando " + command + " ainda n\u00e3o dispon\u00edvel.");
                System.exit(ExitCode.FAILURE.getCode());
                return;
            }
        }
        if (console.login()) {
            System.out.println("Execu\u00e7\u00e3o de comando " + command + "...");
            ExitCode exitCode = console.execute();
            console.logout();
            System.exit(exitCode.getCode());
        }
        System.exit(ExitCode.FAILURE.getCode());
    }

    private static void printHelp() {
        System.out.println("Comandos dispon\u00edveis:");
        for (ConsoleOperation op : ConsoleOperation.values()) {
            System.out.println(" - " + op.getCommandName() + ": " + op.getCommandDescription());
        }
        System.out.println("\n");
    }
}

