/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.BasicParams;
import csbase.console.ExitCode;
import csbase.console.ListAlgoCategoriesParams;
import csbase.logic.User;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.remote.ClientRemoteLocator;

class ListAlgoCategories
extends AbstractConsoleApp {
    ListAlgoCategories(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new ListAlgoCategoriesParams();
    }

    @Override
    protected void postLoginInit() {
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        ListAlgoCategoriesParams params = (ListAlgoCategoriesParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    @Override
    public ExitCode execute() throws Exception {
        return ListAlgoCategories.startAlgorithmCategoriesList();
    }

    private static ExitCode startAlgorithmCategoriesList() throws Exception {
        CategorySet categorySet = ClientRemoteLocator.algorithmService.getAllCategories();
        if (categorySet == null || categorySet.isEmpty()) {
            System.err.println("Nenhuma categoria de algoritmo encontrada.");
            return ExitCode.SUCCESS;
        }
        System.out.println("Categorias de algoritmo encontradas:");
        for (Category category : categorySet.getAllCategories()) {
            System.out.println("Categoria: " + category.getFullName());
        }
        return ExitCode.SUCCESS;
    }
}

