package csbase.adapter.project;

import csbase.logic.CommonClientProject;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import ibase.exception.InternalServiceException;
import ibase.project.ProjectInfo;

/**
 * Implementação do Gateway para uma informação de projeto no CSBase.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CSBaseProjectInfo implements ProjectInfo {

  /**
   * Informação de projeto no CSBase
   */
  private UserProjectInfo info;

  /**
   * Construtor.
   * 
   * @param info informação de projeto no CSBase
   */
  CSBaseProjectInfo(UserProjectInfo info) {
    this.info = info;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getId() {
    return (String) info.getProjectId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return info.getProjectName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    ProjectServiceInterface service = ClientRemoteLocator.projectService;
    CommonClientProject ccp;
    try {
      ccp = service.openProject(info.getProjectId(), false);
      return ccp.getDescription();
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Boolean isWritableByUser(String userId) {
    ProjectServiceInterface service = ClientRemoteLocator.projectService;
    try {
      return service.userCanWrite(info.getProjectId(), userId);
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }
}
