/*
 * Decompiled with CFR 0.152.
 */
package csbase.adapter.project;

import csbase.adapter.project.CSBaseProject;
import csbase.adapter.project.CSBaseProjectFile;
import csbase.adapter.project.CSBaseProjectInfo;
import csbase.exception.InfoException;
import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import ibase.common.NotFoundException;
import ibase.exception.InternalServiceException;
import ibase.exception.InvalidParameterException;
import ibase.project.Project;
import ibase.project.ProjectFile;
import ibase.project.ProjectInfo;
import ibase.project.ProjectService;
import ibase.project.SharingType;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public class CSBaseProjectServiceImpl
implements ProjectService {
    public Project createProject(String name, String userId, String description, String type, SharingType sharingType) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        CommonProjectInfo projectInfo = new CommonProjectInfo();
        projectInfo.userId = userId;
        projectInfo.description = description;
        if (type != null) {
            projectInfo.setAttribute("ibase_project_type", (Object)type);
        }
        projectInfo.name = name;
        try {
            CommonClientProject project = service.createProject(projectInfo);
            if (sharingType != null) {
                project.setSharingType(this.getCSBaseSharingType(sharingType));
            }
            return new CSBaseProject(project);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Project updateProject(String projectId, String description, String type, SharingType sharingType) {
        try {
            ProjectServiceInterface service = ClientRemoteLocator.projectService;
            CommonClientProject project = service.openProject((Object)projectId, false);
            CommonProjectInfo projectInfo = new CommonProjectInfo();
            projectInfo.description = description != null ? description : project.getDescription();
            projectInfo.setAttributes(project.getAttributes());
            String newType = type != null ? type : (String)projectInfo.getAttribute("ibase_project_type");
            projectInfo.setAttribute("ibase_project_type", (Object)newType);
            projectInfo.name = project.getName();
            projectInfo.setAttributes(projectInfo.getAttributes());
            projectInfo = service.modifyProject((Object)projectId, projectInfo);
            project = service.openProject((Object)projectId, false);
            if (sharingType != null) {
                Set usersRO = project.getUsersRO();
                Set usersRW = project.getUsersRW();
                project.updateUsers(this.getCSBaseSharingType(sharingType), usersRO, usersRW);
            }
            return new CSBaseProject(project);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalServiceException(e);
        }
    }

    public Project getProject(String projectId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            CommonClientProject project = service.openProject((Object)projectId, false);
            return new CSBaseProject(project);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public ProjectFile getProjectFile(String projectId, String fileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            ClientProjectFile file = service.getChild((Object)projectId, new String[]{fileId});
            return new CSBaseProjectFile(file);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<ProjectInfo> getProjectsSharedWith(String userId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            List infos = service.getProjectsSharedWithUser((Object)userId);
            return this.filter(infos);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<ProjectInfo> getAllProjects(String userId) {
        ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
        AdministrationServiceInterface adminService = ClientRemoteLocator.administrationService;
        try {
            List users = adminService.getAllUsers();
            ArrayList<UserProjectInfo> allProjects = new ArrayList<UserProjectInfo>();
            for (User user : users) {
                allProjects.addAll(projectService.getProjectsFromUser(user.getId()));
            }
            return this.filter(allProjects);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<ProjectInfo> getProjectsCreatedBy(String userId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            List infos = service.getProjectsFromUser((Object)userId);
            return this.filter(infos);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void removeProject(String projectId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            service.removeProject((Object)projectId);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public boolean existsProjectFile(String projectId, String fileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] path = fileId.split(File.separator);
            return service.existsFile((Object)projectId, path);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void copyFile(String sourceProjectId, String sourceFileId, String targetProjectId, String targetFileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] sourceFilePath = sourceFileId.split(File.separator);
            String[] targetDirPath = targetFileId.split(File.separator);
            service.copyFile((Object)sourceProjectId, sourceFilePath, (Object)targetProjectId, targetDirPath);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void moveFile(String sourceProjectId, String sourceFileId, String targetProjectId, String targetFileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] sourceFilePath = sourceFileId.split(File.separator);
            String[] targetDirPath = targetFileId.split(File.separator);
            service.moveFile((Object)sourceProjectId, sourceFilePath, (Object)targetProjectId, targetDirPath);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public ProjectFile renameFile(String projectId, String fileId, String name) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] path = fileId.split(File.separator);
            service.renameFile((Object)projectId, path, name);
            path[path.length - 1] = name;
            ClientProjectFile newFile = service.getChild((Object)projectId, path);
            return new CSBaseProjectFile(newFile);
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private List<ProjectInfo> filter(List<UserProjectInfo> infos) {
        ArrayList<ProjectInfo> projectInfos = new ArrayList<ProjectInfo>();
        infos.stream().filter(CSBaseProjectServiceImpl.isAvailable()).forEach(i -> projectInfos.add(new CSBaseProjectInfo((UserProjectInfo)i)));
        return projectInfos;
    }

    private static Predicate<UserProjectInfo> isAvailable() {
        return new Predicate<UserProjectInfo>(){

            @Override
            public boolean test(UserProjectInfo info) {
                ProjectServiceInterface service = ClientRemoteLocator.projectService;
                try {
                    ProjectAdminInfo projectAdminInfo = service.getProjectAdminInfo(info.getProjectId());
                    return projectAdminInfo == null || !projectAdminInfo.isLocked() && !projectAdminInfo.isWaitingAreaFree();
                }
                catch (RemoteException e) {
                    return false;
                }
            }
        };
    }

    private ProjectPermissions.SharingType getCSBaseSharingType(SharingType type) {
        switch (type) {
            case PRIVATE: {
                return ProjectPermissions.SharingType.PRIVATE;
            }
            case PUBLIC_RO: {
                return ProjectPermissions.SharingType.ALL_RO;
            }
            case PUBLIC_RW: {
                return ProjectPermissions.SharingType.ALL_RW;
            }
            case SELECTIVE: {
                return ProjectPermissions.SharingType.PARTIAL;
            }
        }
        return null;
    }
}

