/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.AlgorithmExecutionPermission;
import csbase.logic.CategoryAlgorithmsExecutionPermission;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.rest.adapter.algorithm.v1.ActionMapper;
import csbase.rest.adapter.algorithm.v1.ParameterMapper;
import csbase.rest.adapter.algorithm.v1.RequirementsBuilder;
import ibase.common.ServiceAdapter;
import ibase.exception.InternalServiceException;
import ibase.rest.api.algorithm.v1.adapter.AlgorithmNotFoundException;
import ibase.rest.api.algorithm.v1.adapter.AlgorithmServiceAdapter;
import ibase.rest.api.algorithm.v1.adapter.VersionNotFoundException;
import ibase.rest.model.algorithm.v1.Action;
import ibase.rest.model.algorithm.v1.Algorithm;
import ibase.rest.model.algorithm.v1.AlgorithmConfiguration;
import ibase.rest.model.algorithm.v1.AlgorithmVersion;
import ibase.rest.model.algorithm.v1.User;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class CSBaseAlgorithmServiceAdapter
implements AlgorithmServiceAdapter {
    private static final String CURRENT_SYSTEM_ID = ".";
    private static final Logger logger = Logger.getLogger(CSBaseAlgorithmServiceAdapter.class.getName());
    private ParameterMapper parameterMapper = new ParameterMapper();
    private ActionMapper actionMapper = new ActionMapper();

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public boolean existsAlgorithm(String algorithmId) {
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        return this.getAlgorithmInfo(service, algorithmId) != null;
    }

    public boolean existsAlgorithmVersion(String algorithmId, String versionId) throws AlgorithmNotFoundException {
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            AlgorithmInfo algoInfo = this.getAlgorithmInfo(service, algorithmId);
            if (algoInfo == null) {
                throw new AlgorithmNotFoundException();
            }
            AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
            AlgorithmVersionInfo version = algoInfo.getVersionInfo((Object)algoVersionId);
            return version != null;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<Algorithm> getAlgorithms(Predicate<Algorithm> predicate) {
        csbase.logic.User user;
        AlgorithmInfo[] algoInfos;
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            algoInfos = service.getAllInfo();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
        try {
            user = csbase.logic.User.getUserByLogin((String)ServiceAdapter.getCurrenUser());
        }
        catch (Exception e) {
            throw new InternalServiceException((Throwable)e);
        }
        Arrays.asList(algoInfos).stream().sorted().forEach(i -> {
            if (this.userHasPermissionToExecuteAlgorithm(user, (AlgorithmInfo)i)) {
                try {
                    Algorithm a = this.buildAlgorithm((AlgorithmInfo)i);
                    if (predicate == null) {
                        algorithms.add(a);
                    } else if (predicate.test(a)) {
                        algorithms.add(a);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        return algorithms;
    }

    public Optional<Algorithm> getAlgorithm(String algorithmId) {
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            Optional<Algorithm> algorithm = Optional.empty();
            AlgorithmInfo algoInfo = this.getAlgorithmInfo(service, algorithmId);
            if (algoInfo != null) {
                algorithm = Optional.of(this.buildAlgorithm(algoInfo));
            }
            return algorithm;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<AlgorithmVersion> getAlgorithmVersions(String algorithmId) throws AlgorithmNotFoundException {
        AlgorithmInfo algoInfo;
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            algoInfo = this.getAlgorithmInfo(service, algorithmId);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        if (algoInfo == null) {
            throw new AlgorithmNotFoundException();
        }
        Vector versionInfos = algoInfo.getVersions();
        if (versionInfos != null) {
            List<AlgorithmVersion> versions = versionInfos.stream().map(v -> this.buildAlgorithmVersion(algoInfo, (AlgorithmVersionInfo)v)).collect(Collectors.toList());
            return versions;
        }
        return null;
    }

    public Optional<AlgorithmVersion> getAlgorithmVersion(String algorithmId, String versionId) throws AlgorithmNotFoundException {
        AlgorithmInfo algoInfo;
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
        try {
            algoInfo = this.getAlgorithmInfo(service, algorithmId);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        if (algoInfo == null) {
            throw new AlgorithmNotFoundException();
        }
        Optional<AlgorithmVersion> algorithmVersion = Optional.empty();
        AlgorithmVersionInfo version = algoInfo.getVersionInfo((Object)algoVersionId);
        if (version != null) {
            algorithmVersion = Optional.of(this.buildAlgorithmVersion(algoInfo, version));
        }
        return algorithmVersion;
    }

    public AlgorithmConfiguration getAlgorithmConfiguration(String algorithmId, String versionId) throws AlgorithmNotFoundException, VersionNotFoundException {
        if (!this.existsAlgorithm(algorithmId)) {
            throw new AlgorithmNotFoundException();
        }
        if (!this.existsAlgorithmVersion(algorithmId, versionId)) {
            throw new VersionNotFoundException();
        }
        AlgorithmConfiguration algorithmConfig = new AlgorithmConfiguration();
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
        try {
            AlgorithmConfigurator configurator = service.createAlgorithmConfigurator(algorithmId, algoVersionId);
            if (SimpleAlgorithmConfigurator.class.isInstance(configurator)) {
                SimpleAlgorithmConfigurator simpleConfigurator = (SimpleAlgorithmConfigurator)SimpleAlgorithmConfigurator.class.cast(configurator);
                List groups = simpleConfigurator.getGroups();
                algorithmConfig.setGroups(groups.stream().map(g -> this.buildParameterGroup((ParameterGroup)g)).collect(Collectors.toList()));
                algorithmConfig.setCommand(simpleConfigurator.getCommandBinaryName());
                algorithmConfig.setExecutionType(this.getExecutionType(simpleConfigurator.getExecutionType()));
                Set triggers = simpleConfigurator.getTriggers();
                if (triggers != null && !triggers.isEmpty()) {
                    ArrayList<Action> actions = new ArrayList<Action>();
                    for (Trigger trigger : triggers) {
                        Action action = this.buildTriggerAction(trigger);
                        actions.add(action);
                    }
                    algorithmConfig.setActions(actions);
                }
                algorithmConfig.setLoadParameters(simpleConfigurator.allowParametersLoad());
            }
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        return algorithmConfig;
    }

    private Action buildTriggerAction(Trigger trigger) {
        Action action = new Action();
        Action.NameEnum actionType = this.actionMapper.getActionFor(trigger.getClass());
        action.setName(actionType);
        Parameter parameter = trigger.getParameter();
        action.setTargetId(parameter.getName());
        Condition condition = trigger.getCondition();
        if (SimpleCondition.class.isInstance(condition)) {
            ibase.rest.model.algorithm.v1.Condition jsonCondition = new ibase.rest.model.algorithm.v1.Condition();
            SimpleCondition simpleCondition = (SimpleCondition)SimpleCondition.class.cast(condition);
            jsonCondition.setParameterId(simpleCondition.getParameterName());
            Object value = simpleCondition.getValue();
            jsonCondition.setValue(value);
            action.setCondition(jsonCondition);
        }
        return action;
    }

    private Algorithm buildAlgorithm(AlgorithmInfo info) {
        Vector versions;
        Algorithm algorithm = new Algorithm();
        algorithm.setName(info.getName());
        algorithm.setId(info.getId());
        String owner = info.getOwner();
        if (owner != null) {
            algorithm.setWhoCreated(this.buildRestUser(owner));
        }
        if ((versions = info.getVersions()) != null) {
            algorithm.setVersions(versions.stream().map(v -> this.buildAlgorithmVersion(info, (AlgorithmVersionInfo)v)).collect(Collectors.toList()));
            AlgorithmVersionInfo lastVersion = info.getLastVersion();
            if (lastVersion != null) {
                algorithm.setLastVersion(this.buildAlgorithmVersion(info, lastVersion));
            }
        }
        return algorithm;
    }

    private User buildRestUser(String userId) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(ServiceAdapter.getURI());
        Response response = target.path("users").path(userId).queryParam("locale", new Object[]{ClientRemoteLocator.administrationService.getCurrentLocale()}).request(new String[]{"application/json;charset=UTF-8"}).header("Authorization", (Object)ServiceAdapter.getAutheticationHeader()).get();
        if (response.getStatus() != 200) {
            return null;
        }
        User restUser = (User)response.readEntity(User.class);
        return restUser;
    }

    private AlgorithmVersion buildAlgorithmVersion(AlgorithmInfo algoInfo, AlgorithmVersionInfo versionInfo) {
        AlgorithmVersion version = new AlgorithmVersion();
        version.setId(versionInfo.getId().toString());
        try {
            AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
            AlgorithmConfigurator configurator = service.createAlgorithmConfigurator(algoInfo.getId(), versionInfo.getId());
            version.setDescription(configurator.getDescription());
        }
        catch (RemoteException service) {
            // empty catch block
        }
        RequirementsBuilder mapper = new RequirementsBuilder(algoInfo.getId(), versionInfo.getId(), ClientRemoteLocator.administrationService.getCurrentLocale());
        version.setRequirements(mapper.requirements);
        return version;
    }

    private ibase.rest.model.algorithm.v1.ParameterGroup buildParameterGroup(ParameterGroup group) {
        ibase.rest.model.algorithm.v1.ParameterGroup parameterGroup = new ibase.rest.model.algorithm.v1.ParameterGroup();
        parameterGroup.setParameters(group.getSimpleParameters().stream().map(p -> this.parameterMapper.getFactoryFor(p.getType()).buildParameter((SimpleParameter)p)).collect(Collectors.toList()));
        parameterGroup.setId(group.getName());
        parameterGroup.setLabel(group.getLabel());
        parameterGroup.setCollapsable(Boolean.valueOf(group.isCollapsible()));
        return parameterGroup;
    }

    private AlgorithmConfiguration.ExecutionTypeEnum getExecutionType(ExecutionType type) {
        switch (type) {
            case SIMPLE: {
                return AlgorithmConfiguration.ExecutionTypeEnum.SIMPLE;
            }
            case MULTIPLE: {
                return AlgorithmConfiguration.ExecutionTypeEnum.MULTIPLE;
            }
        }
        return null;
    }

    private AlgorithmInfo getAlgorithmInfo(AlgorithmServiceInterface service, String algorithmId) throws InternalServiceException {
        try {
            AlgorithmInfo algoInfo = service.getInfo((Object)algorithmId);
            return algoInfo != null && !this.userHasPermissionToExecuteAlgorithm(csbase.logic.User.getUserByLogin((String)ServiceAdapter.getCurrenUser()), algoInfo) ? null : algoInfo;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private boolean userHasPermissionToExecuteAlgorithm(csbase.logic.User user, AlgorithmInfo algoInfo) {
        try {
            String algorithmName = algoInfo.getName();
            CategorySet allCategories = ClientRemoteLocator.algorithmService.getAllCategories();
            List categoriesFullNames = allCategories.getAlgorithmCategoriesFullNames(algoInfo);
            return user.isAdmin() || AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((csbase.logic.User)user, (String)CURRENT_SYSTEM_ID, (String)algorithmName) || CategoryAlgorithmsExecutionPermission.checkSystemAndCategoriesExecPermission((csbase.logic.User)user, (String)CURRENT_SYSTEM_ID, (List)categoriesFullNames);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erro no metodo userHasPermissionToExecuteAlgorithm", e);
            return false;
        }
    }

    public String getAlgorithmDirPath(Object algorithmId, int versionMajor, int versionMinor, int versionPath, String platformId) {
        try {
            AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
            AlgorithmInfo info = service.getInfo(algorithmId);
            return info.getAlgorithmRepositoryPath() + File.separator + info.getDirectory() + File.separator + "versions" + File.separator + AlgorithmVersionInfo.getDirectoryFor((int)versionMajor, (int)versionMinor, (int)versionPath) + File.separator + "bin" + File.separator + platformId;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erro no metodo getAlgorithmDirPath", e);
            return null;
        }
    }
}

