package csbase.server.services.opendreamsservice.opendreams.v1_8;

import tecgraf.openbus.DRMAA.v1_8.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.v1_8.AuthorizationException;
import tecgraf.openbus.DRMAA.v1_8.DeniedByDrmException;
import tecgraf.openbus.DRMAA.v1_8.DrmCommunicationException;
import tecgraf.openbus.DRMAA.v1_8.ExitTimeoutException;
import tecgraf.openbus.DRMAA.v1_8.InternalException;
import tecgraf.openbus.DRMAA.v1_8.InvalidArgumentException;
import tecgraf.openbus.DRMAA.v1_8.InvalidContactStringException;
import tecgraf.openbus.DRMAA.v1_8.InvalidJobException;
import tecgraf.openbus.DRMAA.v1_8.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.v1_8.JobControlAction;
import tecgraf.openbus.DRMAA.v1_8.JobInfo;
import tecgraf.openbus.DRMAA.v1_8.JobState;
import tecgraf.openbus.DRMAA.v1_8.JobTemplate;
import tecgraf.openbus.DRMAA.v1_8.NoActiveSessionException;
import tecgraf.openbus.DRMAA.v1_8.Version;

/**
 * Implementa a idl <code>Session</code> do DRMAA.
 *
 * @author Tecgraf PUC-Rio
 *
 */
public abstract class Session extends tecgraf.openbus.DRMAA.v1_8.SessionPOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract JobInfo _wait(String jobName, long timeout)
    throws AuthorizationException, ExitTimeoutException, InternalException,
    InvalidJobException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String contact();

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void control(String jobName, JobControlAction operation)
    throws NoActiveSessionException, AuthorizationException,
    InvalidArgumentException, InvalidJobException, DrmCommunicationException,
    InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract JobTemplate createJobTemplate()
    throws AuthorizationException, NoActiveSessionException, InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void deleteJobTemplate(JobTemplate jobTemplate)
    throws InvalidJobTemplateException, AuthorizationException,
    NoActiveSessionException, InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String drmaaImplementation();

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String drmsInfo();

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void exit() throws AuthorizationException,
  NoActiveSessionException, InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void init(String contactString)
    throws AlreadyActiveSessionException, InternalException,
    AuthorizationException, InvalidContactStringException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract JobState jobStatus(String jobName)
    throws AuthorizationException, InternalException, InvalidJobException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String[] runBulkJobs(JobTemplate jobTemplate, int beginIndex,
    int endIndex, int step) throws InvalidArgumentException, InternalException,
    AuthorizationException, DeniedByDrmException, InvalidJobTemplateException,
    NoActiveSessionException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String runJob(JobTemplate jobTemplate)
    throws InternalException, AuthorizationException, DeniedByDrmException,
    InvalidJobTemplateException, NoActiveSessionException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void synchronize(String[] jobList, long timeout,
    boolean dispose) throws AuthorizationException, ExitTimeoutException,
    InternalException, InvalidJobException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract Version version();
}
