package csbase.server.services.schedulerservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import csbase.logic.CommandInfo;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import csbase.server.services.sgaservice.SGAService;

/**
 * Poltica de escalonamento que privilegia os SGAs com maior porcentagem de CPU
 * disponvel.
 *
 * @author valeria
 *
 */
public class PercCPUPolicy implements SchedulerPolicyInterface {
  @Override
  public String chooseServer(CommandInfo command, List<String> serversNames) {
    List<String> sgasNames;

    sgasNames = getSortedSGAByCPU(serversNames);

    if (sgasNames.size() != 0) {
      return sgasNames.get(0);
    }
    return null;
  }

  @Override
  public List<String> chooseServers(CommandInfo command,
    List<String> serversNames, int numServers) {
    List<String> sgasNames;

    sgasNames = getSortedSGAByCPU(serversNames);

    if (sgasNames.size() >= numServers) {
      return sgasNames.subList(0, numServers);
    }
    return null;
  }

  /**
   * Ordena os SGAs de acordo com as suas porcentagens de CPU livre.
   *
   * @param serversNames Lista de servidores disponveis
   *
   * @return Lista de SGAs ordenados de forma decrescente pela quantidade de CPU
   *         livre
   */
  private List<String> getSortedSGAByCPU(List<String> serversNames) {
    List<SGASet> sgasSets = new ArrayList<SGASet>();
    List<String> sgasNames = new ArrayList<String>();
    SGAService sgaService = SGAService.getInstance();

    for (int i = 0; i < serversNames.size(); i++) {
      SGASet sgaSet = sgaService.getSGASet(serversNames.get(i));
      if (sgaSet != null) {
        SGAInfo[] infos = sgaSet.getAllInfo();
        if (infos != null && infos.length > 0) {
          Boolean available = Boolean.FALSE;
          for (SGAInfo info : infos) {
            available = available || info.getAlive();
          }
          if (available) {
            sgasSets.add(sgaSet);
          }
        }
      }
    }
    Collections.sort(sgasSets, new SGASetCPUComparator());
    for (SGASet sga : sgasSets) {
      sgasNames.add(sga.getName());
    }
    return sgasNames;
  }

}
