/**
 * $Id: SSLContext.java 163065 2015-03-27 18:41:34Z fpina $
 */
package csbase.server.services.sgaservice.ssl;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableInterceptor.InvalidSlot;

import tecgraf.openbus.exception.OpenBusInternalException;
import csbase.server.Server;

/**
 * Contexto de chamadas SSL no ORB.
 *
 * @author Tecgraf/PUC-Rio
 */
public class SSLContext extends LocalObject {
  /**
   * Identificador da referncia do contexto no ORB.
   */
  public static final String INITIAL_REFERENCE_ID = SSLContext.class
    .getSimpleName();
  /**
   * Referncia para o ORB.
   */
  private ORB orb;
  /**
   * O identificador do slot.
   */
  private int slotId;

  /**
   * Construtor.
   *
   * @param slotId identificador do slot do contexto.
   */
  SSLContext(int slotId) {
    this.slotId = slotId;
  }

  /**
   * Obtm o contexto SSL do ORB.
   *
   * @param orb o ORB.
   *
   * @return o contexto SSL.
   */
  public static SSLContext getSSLContext(ORB orb) {
    org.omg.CORBA.Object obj = null;
    try {
      obj = orb.resolve_initial_references(SSLContext.INITIAL_REFERENCE_ID);
    }
    catch (InvalidName e) {
      e.printStackTrace();
    }
    if (obj == null) {
      Server.logSevereMessage("O contexto SSL no foi encontrado.");
    }
    return (SSLContext) obj;
  }

  /**
   * Obtm o identificador do slot do contexto.
   *
   * @return o identificador do slot
   */
  public int getSlotId() {
    return slotId;
  }

  /**
   * Configura o ORB ao qual esta classe esta associada
   *
   * @param orb o ORB
   */
  public void setORB(ORB orb) {
    this.orb = orb;
  }

  /**
   * Recupera o ORB ao qual esta classe esta associada
   *
   * @return o ORB
   */
  public ORB getORB() {
    return this.orb;
  }

  /**
   * Recupera o {@link Current} da thread em execuo do ORB associado.
   *
   * @param orb o orb utilizado.
   * @return o {@link Current}.
   * @throws OpenBusInternalException
   */
  private Current getPICurrent(ORB orb) {
    org.omg.CORBA.Object obj = null;
    try {
      obj = orb.resolve_initial_references("PICurrent");
    }
    catch (InvalidName e) {
      Server.logSevereMessage("Erro ao obtr o PICurrent", e);
    }
    return CurrentHelper.narrow(obj);
  }

  /**
   * Recupera a informao que foi embutida no contexto da chamada.
   *
   * @return a informao.
   */
  public String getContextInformation() {
    Current current = getPICurrent(orb);
    try {
      Any any = current.get_slot(slotId);
      if (any.type().kind().value() == TCKind._tk_null) {
        return null;
      }
      return any.extract_string();
    }
    catch (InvalidSlot e) {
      Server.logSevereMessage(
        "No foi possvel recuperar informao no slotId", e);

      return null;
    }
  }

  /**
   * Configura a informao a ser embutida no contexto da chamada. Caso a
   * informao sendo configurada for nula, ento a informao  removida do
   * contexto de chamadas.
   *
   * @param info a informao.
   */
  public void setContextInformation(String info) {
    Current current = getPICurrent(orb);
    Any any = orb.create_any();
    if (info != null) {
      any.insert_string(info);
    }
    try {
      current.set_slot(slotId, any);
    }
    catch (InvalidSlot e) {
      Server
      .logSevereMessage("No foi possvel salvar informao no slotId", e);
    }
  }

  /**
   * Limpa a informao a ser associada ao contexto das chamadas CORBA.
   */
  public void clearContextInformation() {
    setContextInformation(null);
  }
}
