/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.keystore;

import csbase.exception.OperationFailureException;
import csbase.server.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CSKeyStore {
    private static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    private static final String KEYSTORE_TYPE = "JKS";
    private KeyStore keyStore;
    private static CSKeyStore instance;
    private char[] password;
    private long lastSynchronizationDate;
    private File keyStoreFile;
    private ReadWriteLock keyStoreLock;

    private CSKeyStore(String pathName, char[] password) {
        if (pathName == null) {
            String err = "A localiza\u00e7\u00e3o do arquivo do rep. de chaves est\u00e1 null";
            throw new IllegalArgumentException("A localiza\u00e7\u00e3o do arquivo do rep. de chaves est\u00e1 null");
        }
        this.password = password;
        this.keyStoreFile = new File(pathName);
        this.resetKeyStoreData();
        this.keyStoreLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void synchronize() {
        this.keyStoreLock.writeLock().lock();
        try {
            this.loadKeyStore();
        }
        finally {
            this.keyStoreLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyStore() {
        KeyStore keyStoreTemp;
        FileInputStream fileInputStream;
        if (this.lastSynchronizationDate == this.keyStoreFile.lastModified()) {
            return;
        }
        this.resetKeyStoreData();
        try {
            fileInputStream = new FileInputStream(this.keyStoreFile);
        }
        catch (FileNotFoundException e) {
            String fmt = "O arquivo do rep. de chaves n\u00e3o existe. Caminho: {0}.";
            String keyStoreFileName = this.keyStoreFile.getName();
            String err = MessageFormat.format("O arquivo do rep. de chaves n\u00e3o existe. Caminho: {0}.", keyStoreFileName);
            Server.logSevereMessage(err, e);
            return;
        }
        try {
            try {
                keyStoreTemp = KeyStore.getInstance(KEYSTORE_TYPE);
            }
            catch (KeyStoreException e) {
                String fmt = "Tipo para chaves/certificados {0} n\u00e3o existe.";
                String err = MessageFormat.format("Tipo para chaves/certificados {0} n\u00e3o existe.", KEYSTORE_TYPE);
                Server.logSevereMessage(err, e);
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    String err2 = "Falha ao fechar rep. de chaves/certificados.";
                    Server.logSevereMessage("Falha ao fechar rep. de chaves/certificados.", e2);
                }
                return;
            }
            String err = "Falha no arquivo do rep. de chaves/certificados.";
            try {
                keyStoreTemp.load(fileInputStream, this.password);
            }
            catch (IOException e) {
                Server.logSevereMessage("Falha no arquivo do rep. de chaves/certificados.", e);
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    String err3 = "Falha ao fechar rep. de chaves/certificados.";
                    Server.logSevereMessage("Falha ao fechar rep. de chaves/certificados.", e3);
                }
                return;
            }
            catch (GeneralSecurityException e) {
                Server.logSevereMessage("Falha no arquivo do rep. de chaves/certificados.", e);
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                    String err4 = "Falha ao fechar rep. de chaves/certificados.";
                    Server.logSevereMessage("Falha ao fechar rep. de chaves/certificados.", e4);
                }
                return;
            }
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
                String err = "Falha ao fechar rep. de chaves/certificados.";
                Server.logSevereMessage("Falha ao fechar rep. de chaves/certificados.", e);
            }
        }
        this.keyStore = keyStoreTemp;
        this.lastSynchronizationDate = this.keyStoreFile.lastModified();
    }

    private void resetKeyStoreData() {
        this.keyStore = null;
        this.lastSynchronizationDate = -1L;
    }

    public byte[] sign(String alias, String privateKeyPassword, String data) throws OperationFailureException {
        if (alias == null) {
            String err = "O nome da entidade n\u00e3o pode ser nulo.";
            throw new IllegalArgumentException("O nome da entidade n\u00e3o pode ser nulo.");
        }
        if (privateKeyPassword == null) {
            String err = "A senha da chave privada da entidade n\u00e3o pode ser nula.";
            throw new IllegalArgumentException("A senha da chave privada da entidade n\u00e3o pode ser nula.");
        }
        if (data == null) {
            String err = "O dado a ser assinado n\u00e3o pode ser nulo.";
            throw new IllegalArgumentException("O dado a ser assinado n\u00e3o pode ser nulo.");
        }
        PrivateKey privateKey = this.getKey(alias, privateKeyPassword);
        if (privateKey == null) {
            return null;
        }
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(privateKey);
            signature.update(data.getBytes());
            return signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new OperationFailureException((Throwable)e);
        }
    }

    private PrivateKey getKey(String alias, String privateKeyPassword) throws OperationFailureException {
        this.synchronize();
        this.keyStoreLock.readLock().lock();
        try {
            if (this.keyStore == null) {
                PrivateKey privateKey = null;
                return privateKey;
            }
            PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, privateKeyPassword.toCharArray());
            return privateKey;
        }
        catch (GeneralSecurityException e) {
            throw new OperationFailureException((Throwable)e);
        }
        finally {
            this.keyStoreLock.readLock().unlock();
        }
    }

    public boolean verify(String alias, String data, byte[] signedData) throws OperationFailureException {
        Certificate certificate = this.getCertificate(alias);
        if (certificate == null) {
            return false;
        }
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(certificate);
            signature.update(data.getBytes());
            return signature.verify(signedData);
        }
        catch (GeneralSecurityException e) {
            throw new OperationFailureException((Throwable)e);
        }
    }

    public boolean containsAlias(String alias) throws OperationFailureException {
        this.synchronize();
        this.keyStoreLock.readLock().lock();
        try {
            if (this.keyStore == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.keyStore.containsAlias(alias);
            return bl;
        }
        catch (KeyStoreException e) {
            throw new OperationFailureException((Throwable)e);
        }
        finally {
            this.keyStoreLock.readLock().unlock();
        }
    }

    public Certificate getCertificate(String alias) throws OperationFailureException {
        this.synchronize();
        this.keyStoreLock.readLock().lock();
        try {
            if (this.keyStore == null) {
                Certificate certificate = null;
                return certificate;
            }
            Certificate certificate = this.keyStore.getCertificate(alias);
            return certificate;
        }
        catch (KeyStoreException e) {
            throw new OperationFailureException((Throwable)e);
        }
        finally {
            this.keyStoreLock.readLock().unlock();
        }
    }

    public static void createInstance(String pathName) {
        if (instance != null) {
            String err = "J\u00e1 existe inst\u00e2ncia de rep. de chaves/certificados!";
            throw new IllegalStateException("J\u00e1 existe inst\u00e2ncia de rep. de chaves/certificados!");
        }
        instance = new CSKeyStore(pathName, null);
    }

    public static void createInstance(String pathName, String password) {
        if (password == null) {
            String err = "N\u00e3o \u00e9 permitido criar uma inst\u00e2ncia com senha nula.";
            throw new IllegalArgumentException("N\u00e3o \u00e9 permitido criar uma inst\u00e2ncia com senha nula.");
        }
        if (instance != null) {
            String err = "J\u00e1 existe inst\u00e2ncia de rep. de chaves/certificados.";
            throw new IllegalStateException("J\u00e1 existe inst\u00e2ncia de rep. de chaves/certificados.");
        }
        instance = new CSKeyStore(pathName, password.toCharArray());
    }

    public static CSKeyStore getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCertificate(String alias, Certificate cert) {
        if (alias == null || cert == null) {
            throw new IllegalArgumentException("alias == null || cert == null");
        }
        try {
            boolean containsFlag;
            this.keyStoreLock.writeLock().lock();
            if (this.keyStore == null) {
                boolean bl = false;
                return bl;
            }
            this.keyStore.setCertificateEntry(alias, cert);
            this.writeKeyStore();
            boolean bl = containsFlag = this.keyStore.containsAlias(alias);
            return bl;
        }
        catch (KeyStoreException e) {
            String err = "N\u00e3o foi poss\u00edvel adicionar o cert. para a entidade:";
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel adicionar o cert. para a entidade:" + alias, e);
        }
        finally {
            this.keyStoreLock.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyStore() {
        try {
            this.keyStoreLock.writeLock().lock();
            FileOutputStream out = new FileOutputStream(this.keyStoreFile);
            this.keyStore.store(out, this.password);
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            String fmt = "Arquivo do rep. de chaves n\u00e3o existe. Caminho: {0}.";
            String keyStoreFileName = this.keyStoreFile.getName();
            String err = MessageFormat.format("Arquivo do rep. de chaves n\u00e3o existe. Caminho: {0}.", keyStoreFileName);
            Server.logSevereMessage(err, e);
        }
        catch (KeyStoreException e) {
            String err = "KeyStore n\u00e3o inicializado.";
            Server.logSevereMessage("KeyStore n\u00e3o inicializado.", e);
        }
        catch (NoSuchAlgorithmException e) {
            String err = "Algoritmo de verifica\u00e7\u00e3o desconhecido";
            Server.logSevereMessage("Algoritmo de verifica\u00e7\u00e3o desconhecido", e);
        }
        catch (CertificateException e) {
            String err = "Erro salvando certificados";
            Server.logSevereMessage("Erro salvando certificados", e);
        }
        catch (IOException e) {
            String err = "Erro lendo " + this.keyStoreFile;
            Server.logSevereMessage(err, e);
        }
        finally {
            this.keyStoreLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificate(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias == null");
        }
        try {
            this.keyStoreLock.writeLock().lock();
            if (this.keyStore == null) {
                String err = "N\u00e3o existe keystore para remover o certificado de:";
                Server.logSevereMessage("N\u00e3o existe keystore para remover o certificado de:" + alias);
                return;
            }
            if (this.keyStore.containsAlias(alias)) {
                this.keyStore.deleteEntry(alias);
                this.writeKeyStore();
            }
        }
        catch (KeyStoreException e) {
            String err = "N\u00e3o foi poss\u00edvel remover o certificado para: ";
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel remover o certificado para: " + alias, e);
        }
        finally {
            this.keyStoreLock.writeLock().unlock();
        }
    }
}

