/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.disk;

import csbase.logic.diagnosticservice.DiskStatus;
import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.AbstractMonitor;
import csbase.server.services.diagnosticservice.monitors.disk.DiskOcupationValidation;
import csbase.server.services.diskusageservice.DiskUsageService;
import java.text.NumberFormat;
import java.util.Locale;

public class DiskMonitor
extends AbstractMonitor {
    public DiskMonitor() throws ResourceException {
        super("server");
        this.addValidation(new DiskOcupationValidation());
    }

    @Override
    public synchronized Status checkResource(Locale locale) throws ResourceException {
        DiskOccupation serverDiskOccupation = DiskUsageService.getInstance().getAreaOccupation("server");
        this.addPropertiesForServerDisk(locale, serverDiskOccupation);
        Status status = super.checkResource(locale);
        return new DiskStatus(serverDiskOccupation, status.getResourceName(), status.getCode(), status.getValidationStatusList(), status.getProperties());
    }

    private void addPropertiesForServerDisk(Locale locale, DiskOccupation serverDiskOccupation) {
        this.cleanProperties();
        double usedSpacePerc = serverDiskOccupation.getUsedSpacePerc() / 100.0;
        double freeSpacePerc = serverDiskOccupation.getFreeSpacePerc() / 100.0;
        long usedSpaceGb = (long)serverDiskOccupation.getUsedSpaceMb() / 1024L;
        long freeSpaceGb = (long)serverDiskOccupation.getFreeSpaceMb() / 1024L;
        long alertLimit = serverDiskOccupation.alertLimit;
        long warningLimit = serverDiskOccupation.warningLimit;
        boolean auditEnabled = DiskUsageService.getInstance().isAuditEnabled();
        boolean mailOnAlert = DiskUsageService.getInstance().isMailOnAlertEnabled();
        int auditInterval = DiskUsageService.getInstance().getAuditIntervalHours();
        int auditTimeout = DiskUsageService.getInstance().getUsageQueryTimeout();
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.usage.percentual.label", locale), NumberFormat.getPercentInstance(locale).format(usedSpacePerc), null);
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.free.percentual.label", locale), NumberFormat.getPercentInstance(locale).format(freeSpacePerc), null);
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.usage.gb.label", locale), MessageTranslator.getString("server.disksmonitor.server.usage.gb.value", new String[]{Long.toString(usedSpaceGb)}, locale), null);
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.free.gb.label", locale), MessageTranslator.getString("server.disksmonitor.server.free.gb.value", new String[]{Long.toString(freeSpaceGb)}, locale), null);
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.alert.percentual.label", locale), MessageTranslator.getString("server.disksmonitor.server.alert.percentual.value", new String[]{Long.toString(alertLimit)}, locale), "DiskUsageService.alertPercentage");
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.warning.percentual.label", locale), MessageTranslator.getString("server.disksmonitor.server.warning.percentual.value", new String[]{Long.toString(warningLimit)}, locale), "DiskUsageService.warningPercentage");
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.audit.enable", locale), Boolean.toString(auditEnabled), "DiskUsageService.enableAudit");
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.mail.on.alert", locale), Boolean.toString(mailOnAlert), "DiskUsageService.mailOnAlert");
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.audit.interval.label", locale), MessageTranslator.getString("server.disksmonitor.server.audit.interval.value", new String[]{Integer.toString(auditInterval)}, locale), "DiskUsageService.auditIntervalHours");
        this.addProperty(MessageTranslator.getString("server.disksmonitor.server.audit.timeout.label", locale), MessageTranslator.getString("server.disksmonitor.server.audit.timeout.value", new String[]{Integer.toString(auditTimeout)}, locale), "DiskUsageService.usageQueryTimeout");
    }
}

