/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_8;

import csbase.exception.PermissionException;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v1_8.SessionManager;
import csbase.server.services.projectservice.ProjectService;
import java.lang.reflect.Field;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import tecgraf.openbus.DRMAA.v1_8.AuthorizationException;
import tecgraf.openbus.DRMAA.v1_8.InternalException;
import tecgraf.openbus.DRMAA.v1_8.Session;
import tecgraf.openbus.DRMAA.v1_8.SessionHelper;
import tecgraf.openbus.opendreams.v1_8.IOpenDreamsPOA;
import tecgraf.openbus.opendreams.v1_8.ProjectNotFoundException;

public class OpenDreams
extends IOpenDreamsPOA {
    private Session session;
    private SessionManager sessionManagement = new SessionManager();
    public static final String UNDEFINED = "indefinido";

    public Session getSession(String projectName) throws AuthorizationException, InternalException, ProjectNotFoundException {
        String userId = UNDEFINED;
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreams: getSession (" + projectName + ")");
            OpenDreams.checkUser(userId);
            OpenDreams.checkProject(projectName, userId);
            POA poa = OpenBusService.getInstance().getRootPOA();
            Object obj = poa.servant_to_reference((Servant)this.sessionManagement.getSession(userId, projectName));
            this.session = SessionHelper.narrow((Object)obj);
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ProjectNotFoundException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro ao obter a sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return this.session;
    }

    public Session getSessionByProjUserId(String projectName, String userName) throws AuthorizationException, InternalException, ProjectNotFoundException {
        String userId = UNDEFINED;
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreams: getSessionByProjUserId (" + projectName + ", " + userName + ")");
            OpenDreams.checkUser(userId);
            OpenDreams.checkProject(projectName, userName);
            OpenDreams.checkProjectPermission(projectName, userName);
            POA poa = OpenBusService.getInstance().getRootPOA();
            Object obj = poa.servant_to_reference((Servant)this.sessionManagement.getSession(userName, projectName));
            this.session = SessionHelper.narrow((Object)obj);
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ProjectNotFoundException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro ao obter a sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return this.session;
    }

    public static String formatMessage(Throwable e, String msg) {
        StringBuffer message = new StringBuffer(msg);
        message.append(": " + e.getClass().getName() + ": " + e.getMessage());
        message.append("\nCaused by:\n");
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            message.append(stackTrace[i].toString() + "\n");
        }
        return message.toString();
    }

    public static void checkUser(String userId) throws AuthorizationException {
        if (AdministrationService.getInstance().getUser(userId) == null) {
            throw new AuthorizationException("O usu\u00e1rio " + userId + " n\u00e3o existe.");
        }
    }

    public static void checkProject(String projectName, String userId) throws ProjectNotFoundException {
        java.lang.Object projectId;
        if (AdministrationService.getInstance().getUser(userId) == null) {
            throw new ProjectNotFoundException("N\u00e3o existe um usu\u00e1rio com identificador " + userId);
        }
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsProject(projectId = projectService.getProjectId(userId, projectName))) {
            throw new ProjectNotFoundException("O usu\u00e1rio " + userId + " n\u00e3o possui um projeto com nome " + projectName);
        }
    }

    public static void checkProjectPermission(String projectName, String userId) throws AuthorizationException {
        ProjectService projectService = ProjectService.getInstance();
        java.lang.Object projectId = projectService.getProjectId(userId, projectName);
        try {
            projectService.checkWritePermission(projectId);
        }
        catch (PermissionException e) {
            throw new AuthorizationException("O usu\u00e1rio " + Service.getUser().getId() + " n\u00e3o possui acesso de escrita no projeto " + projectName + " do usu\u00e1rio " + userId);
        }
    }

    public static void logWarningException(String msg, UserException exception) {
        try {
            Field messageField = exception.getClass().getField("message");
            Server.logWarningMessage(msg + ": " + messageField.get(exception));
        }
        catch (Exception e) {
            Server.logSevereMessage(msg, e);
        }
    }
}

