/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;
import java.util.Map;

public class SGAAuthorization {
    private static final String CERT_TYPE = "X.509";
    private Map<String, Certificate> authorizedSGAs = new Hashtable<String, Certificate>();
    private Map<String, Certificate> authenticatedSGAs = new Hashtable<String, Certificate>();
    private static SGAAuthorization instance;

    private SGAAuthorization() {
    }

    public static synchronized SGAAuthorization getInstance() {
        if (instance == null) {
            instance = new SGAAuthorization();
        }
        return instance;
    }

    public void addSGACertificate(String name, String certificateFile) throws FileNotFoundException, CertificateException {
        FileInputStream fis = new FileInputStream(certificateFile);
        CertificateFactory cf = CertificateFactory.getInstance(CERT_TYPE);
        this.authorizedSGAs.put(name, cf.generateCertificate(fis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSGA(String name, Certificate certificate) {
        Map<String, Certificate> map = this.authenticatedSGAs;
        synchronized (map) {
            if (this.authorizedSGAs.containsKey(name)) {
                this.authenticatedSGAs.put(name, certificate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSGA(String name) {
        if (!this.authorizedSGAs.containsKey(name)) {
            return false;
        }
        Map<String, Certificate> map = this.authenticatedSGAs;
        synchronized (map) {
            if (!this.authenticatedSGAs.containsKey(name)) {
                return false;
            }
            Certificate cert = this.authenticatedSGAs.remove(name);
            return cert.equals(this.authorizedSGAs.get(name));
        }
    }
}

