/*
 * $Id$
 */

package csbase.server;

import java.util.logging.LogManager;

/**
 * Soluo para contornar deficincia da api de ShutdownHook que no 
 * disponibiliza meios de ordenar as threads de hook que so executadas 
 * concorrentementes podendo fazer com que o log seja fechado precocemente 
 * antes do shutdown de todos os servios. 
 * 
 * Esta classe  final, pois ela no  mais definvel pelo script
 * "runserver". Agora est est amarrada (como sempre) na incializao
 * do servidor (@link Server#Server(String[])).
 * 
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5036297
 * 
 * @author Tecgraf/PUC-Rio
 */
final public class ServiceLogManager extends LogManager {
  /**
   * {@inheritDoc}
   */
  @Override
  public void reset() throws SecurityException {
    try {
      final ServiceManager serviceManager = ServiceManager.getInstance();
      if (serviceManager != null) {
        serviceManager.shutdownAllServices();
      }
    }
    catch (final ServerException se) {}
    super.reset();
  }
}
