package csbase.server.services.administrationservice;

import java.io.IOException;
import java.util.List;

import csbase.logic.Platform;
import csbase.logic.PlatformInfo;

/**
 * Implementao padro do DAO de plataforma. Utiliza armazenamento em arquivo
 * (serializao de objetos).
 * 
 * @see DefaultAdministrationDAOFactory
 * @author Jorge Alexandre
 * 
 */
public class DefaultPlatformDAO implements PlatformDAO {

  private PlatformIO platformRepository;

  public DefaultPlatformDAO() {
    this.platformRepository = new PlatformIO();
  }

  public Platform createPlatform(PlatformInfo info) throws DAOException {
    Platform platform;
    try {
      platform = platformRepository.writeNew(info);
    }
    catch (IOException e) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "]";
      throw new DAOException(e, operationInfo);
    }
    if (platform == null) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "]";
      throw new DAOException("Falha em PlatformIO.writeNew", operationInfo);
    }
    return platform;
  }

  public void deletePlatform(Object id) throws DAOException {
    try {
      platformRepository.delete(id);
    }
    catch (IOException e) {
      throw new DAOException(e, "id: " + id);
    }
  }

  public Platform modifyPlatform(Object id, PlatformInfo info)
    throws DAOException {
    Platform platform;
    try {
      platform = platformRepository.write(id, info);
    }
    catch (IOException e) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "] - para o usurio: " + id;
      throw new DAOException(e, operationInfo);
    }
    if (platform == null) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "] - para o usurio: " + id;
      throw new DAOException("Falha em PlatformIO.write", operationInfo);
    }
    return platform;
  }

  public List<Platform> readAllPlatforms() throws DAOException {
    try {
      return platformRepository.readAll();
    }
    catch (IOException e) {
      throw new DAOException(e);
    }
  }

  public Platform readPlatform(Object id) throws DAOException {
    try {
      return platformRepository.read(id);
    }
    catch (IOException e) {
      throw new DAOException(e, "id: " + id);
    }
  }

}
