/**
 * $Id$
 */
package csbase.server.services.opendreamsservice;

import csbase.server.ServerException;
import csbase.server.Service;

/**
 * O servio <code>OpenDreams</code> publica um componente no OpenBus para
 * execuo remota de algoritmos usando uma interface DRMAA.
 * 
 * @author Tecgraf PUC-Rio
 */
public class OpenDreamsService extends Service {

  /** Nome do servio para o <code>ServiceManager</code> */
  public static final String SERVICE_NAME = "OpenDreamsService";

  /**
   * Construtor default que cadastra esse servio no <code>ServiceManager</code>
   * . Esse construtor  obrigatrio para que o servio seja iniciado no
   * servidor.
   * 
   * @throws ServerException se ocorrer algum erro na inicializao do servio.
   */
  protected OpenDreamsService() throws ServerException {
    super(SERVICE_NAME);
  }

  /**
   * Obtm uma instncia do servio.
   * 
   * @return ProjectService
   */
  public static OpenDreamsService getInstance() {
    return (OpenDreamsService) getInstance(SERVICE_NAME);
  }

  /**
   * {@inheritDoc}
   * 
   * Publica um componente <code>OpenDreams</code> como um servio do OpenBus.
   */
  @Override
  public void initService() throws ServerException {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void shutdownService() throws ServerException {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean has2Update(Object arg, Object event) {
    return false;
  }

  /**
   * Constri a instncia do servio. Esse mtodo  chamado pelo servidor, na
   * criao dos servios.
   * 
   * @throws ServerException se houver falha na criao do servio.
   */
  public static void createService() throws ServerException {
    new OpenDreamsService();
  }
}